/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.mysql.Table;
import be.isach.ultracosmetics.player.profile.PlayerData;
import be.isach.ultracosmetics.util.SmartLogger;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

public class SubCommandMigrate
extends SubCommand {
    public SubCommandMigrate(UltraCosmetics ultraCosmetics) {
        super("migrate", "Moves player data from flatfile to MySQL and vice versa", "<flatfile|sql>", ultraCosmetics);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        if (!(sender instanceof ConsoleCommandSender)) {
            this.error(sender, "This command can only be used from the console.");
            return;
        }
        if (UltraCosmeticsData.get().usingFileStorage()) {
            this.error(sender, "SQL must be enabled and connected to migrate either direction.");
            return;
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("flatfile") && !args[1].equalsIgnoreCase("sql")) {
            this.badUsage(sender);
            return;
        }
        boolean flatfile = args[1].equalsIgnoreCase("flatfile");
        if (args.length < 3 || !args[2].equalsIgnoreCase("confirm")) {
            if (Bukkit.getOnlinePlayers().size() > 0) {
                this.error(sender, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                this.error(sender, "  It is HIGHLY recommended migration is only  ");
                this.error(sender, "performed when no players are online, but you ");
                this.error(sender, "           can decide for yourself!           ");
                this.error(sender, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            String from = flatfile ? "SQL database" : "flatfile";
            String to = flatfile ? "flatfile" : "SQL database";
            this.error(sender, "You are migrating from " + from + " to " + to);
            this.error(sender, "Warning: any conflicting data in " + to + " will be overwritten.");
            this.error(sender, "If you want to proceed, use /uc migrate " + args[1] + " confirm");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.ultraCosmetics, () -> this.migrate(flatfile));
    }

    private void migrate(boolean flatfile) {
        this.ultraCosmetics.getSmartLogger().write("Loading UUIDs to migrate...");
        List<UUID> uuids = flatfile ? this.getFlatfileUUIDs() : this.getSqlUUIDs();
        if (uuids == null) {
            return;
        }
        this.ultraCosmetics.getSmartLogger().write("Found " + uuids.size() + " UUIDs, starting migration");
        for (UUID uuid : uuids) {
            PlayerData data = new PlayerData(uuid);
            if (flatfile) {
                data.loadFromSQL();
                data.saveToFile();
            } else {
                data.loadFromFile();
                data.saveToSQL();
            }
            this.ultraCosmetics.getSmartLogger().write("Successfully migrated " + uuid.toString());
        }
        this.ultraCosmetics.getSmartLogger().write(uuids.size() + " UUIDs successfully migrated!");
    }

    private List<UUID> getSqlUUIDs() {
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        File dataFolder = new File(this.ultraCosmetics.getDataFolder(), "data");
        for (File file : dataFolder.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            String baseName = file.getName().substring(0, file.getName().length() - 4);
            try {
                uuids.add(UUID.fromString(baseName));
            }
            catch (IllegalArgumentException e) {
                this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Failed to parse UUID of flatfile '" + file.getName() + "', ignoring");
            }
        }
        return uuids;
    }

    private List<UUID> getFlatfileUUIDs() {
        ArrayList<UUID> uuids;
        Table table = this.ultraCosmetics.getMySqlConnectionManager().getTable();
        try (Connection co = this.ultraCosmetics.getMySqlConnectionManager().getDataSource().getConnection();){
            PreparedStatement statement = co.prepareStatement("SELECT uuid FROM " + table.getWrappedName());
            ResultSet set = statement.executeQuery();
            uuids = new ArrayList<UUID>();
            while (set.next()) {
                uuids.add(UUID.fromString(set.getString(1)));
            }
            statement.close();
        }
        catch (SQLException e) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to fetch UUIDs from database, aborting migration");
            e.printStackTrace();
            return null;
        }
        return uuids;
    }
}

