/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.util.MathUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandGive
extends SubCommand {
    public SubCommandGive(UltraCosmetics ultraCosmetics) {
        super("give", "Gives Ammo/Keys", "key [amount] [player] OR /uc give ammo <type> <amount> [player]", ultraCosmetics);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        Player target;
        int targetArg;
        if (args.length < 2 || !args[1].toLowerCase().startsWith("k") && !args[1].toLowerCase().startsWith("a")) {
            this.badUsage(sender);
            return;
        }
        boolean givingKey = args[1].toLowerCase().startsWith("k");
        if (!givingKey && args.length < 4) {
            this.badUsage(sender);
            return;
        }
        int n = targetArg = givingKey ? 3 : 4;
        if (args.length <= targetArg) {
            if (!(sender instanceof Player)) {
                this.error(sender, "You must specify a player.");
                return;
            }
            target = (Player)sender;
        } else {
            target = Bukkit.getPlayer((String)args[targetArg]);
            if (target == null) {
                this.error(sender, "Player " + args[3] + " not found!");
                return;
            }
        }
        if (givingKey) {
            int keys = 1;
            if (args.length > 2) {
                if (!MathUtils.isInteger(args[2])) {
                    this.error(sender, args[2] + " isn't a number!");
                    return;
                }
                keys = Integer.parseInt(args[2]);
            }
            this.addKeys(target, keys);
            sender.sendMessage(ChatColor.GREEN.toString() + keys + " treasure keys given to " + target.getName());
            return;
        }
        if (args.length < 4) {
            this.badUsage(sender, "/uc give ammo <gadget> <amount> [player]");
            return;
        }
        GadgetType gadgetType = GadgetType.valueOf(args[2].toUpperCase());
        if (gadgetType == null) {
            sender.sendMessage(MessageManager.getMessage("Invalid-Gadget"));
            return;
        }
        if (!gadgetType.isEnabled()) {
            this.error(sender, "This gadget isn't enabled!");
            return;
        }
        if (!MathUtils.isInteger(args[3])) {
            this.error(sender, args[3] + " isn't a number!");
            return;
        }
        int ammo = Integer.parseInt(args[3]);
        this.addAmmo(gadgetType, target, ammo);
        sender.sendMessage(ChatColor.GREEN.toString() + ammo + " " + gadgetType.toString().toLowerCase() + " ammo given to " + target.getName());
    }

    private void addKeys(Player player, int amount) {
        this.ultraCosmetics.getPlayerManager().getUltraPlayer(player).addKeys(amount);
    }

    private void addAmmo(GadgetType gadgetType, Player player, int ammo) {
        this.ultraCosmetics.getPlayerManager().getUltraPlayer(player).addAmmo(gadgetType, ammo);
    }
}

