/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.player.UltraPlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandClear
extends SubCommand {
    public SubCommandClear(UltraCosmetics ultraCosmetics) {
        super("clear", "Clears a Cosmetic.", "<player> [type]", ultraCosmetics, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        Player target;
        if (args.length < 2) {
            if (!(sender instanceof Player)) {
                this.error(sender, "You must specify a player.");
                return;
            }
            target = (Player)sender;
        } else {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                this.error(sender, "Player " + args[1] + " not found!");
                return;
            }
        }
        if (target != sender && !sender.hasPermission(this.getPermission() + ".others")) {
            this.error(sender, "You do not have permission to clear others.");
            return;
        }
        if (args.length < 3) {
            this.ultraCosmetics.getPlayerManager().getUltraPlayer(target).clear();
            return;
        }
        UltraPlayer up = this.ultraCosmetics.getPlayerManager().getUltraPlayer(target);
        Category cat = Category.fromString(args[2]);
        if (cat == null) {
            this.error(sender, "Invalid cosmetic type.");
            return;
        }
        if (cat != Category.SUITS) {
            up.removeCosmetic(cat);
            return;
        }
        String[] parts = args[2].split(":");
        if (parts.length < 2) {
            up.removeSuit();
            return;
        }
        up.removeSuit(ArmorSlot.getByName(parts[1]));
    }
}

