/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public abstract class SubCommand {
    private final String name;
    private final String description;
    private final Permission permission;
    private final String usage;
    private final boolean defaultPerm;
    protected final UltraCosmetics ultraCosmetics;

    public SubCommand(String name, String description, String usage, UltraCosmetics ultraCosmetics) {
        this(name, description, usage, ultraCosmetics, false);
    }

    public SubCommand(String name, String description, String usage, UltraCosmetics ultraCosmetics, boolean defaultPerm) {
        this.name = name;
        this.description = description;
        this.permission = this.registerPermission("ultracosmetics.command." + name, defaultPerm);
        this.usage = "/uc " + name + " " + usage;
        this.defaultPerm = defaultPerm;
        this.ultraCosmetics = ultraCosmetics;
    }

    public boolean is(String arg) {
        return this.name.equalsIgnoreCase(arg);
    }

    public String getName() {
        return this.name;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getDescription() {
        return this.description;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public boolean isDefault() {
        return this.defaultPerm;
    }

    private Permission registerPermission(String strPerm, boolean defaultPerm) {
        Permission perm = new Permission(strPerm);
        try {
            Bukkit.getPluginManager().addPermission(perm);
        }
        catch (IllegalArgumentException e) {
            return Bukkit.getPluginManager().getPermission(strPerm);
        }
        perm.setDefault(defaultPerm ? PermissionDefault.TRUE : PermissionDefault.OP);
        return perm;
    }

    protected void onExePlayer(Player sender, String[] args) {
        this.onExeAnyone((CommandSender)sender, args);
    }

    protected abstract void onExeAnyone(CommandSender var1, String[] var2);

    protected void notAllowed(CommandSender commandSender) {
        commandSender.sendMessage(MessageManager.getMessage("Not-Allowed-From-Console"));
    }

    protected void badUsage(CommandSender sender) {
        this.badUsage(sender, this.getUsage());
    }

    protected void badUsage(CommandSender sender, String usage) {
        this.error(sender, "Incorrect Usage. " + usage);
    }

    protected void error(CommandSender sender, String error) {
        sender.sendMessage(ChatColor.RED.toString() + ChatColor.BOLD + error);
    }
}

