/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.command.UCTabCompleter;
import be.isach.ultracosmetics.command.subcommands.SubCommandClear;
import be.isach.ultracosmetics.command.subcommands.SubCommandGadgets;
import be.isach.ultracosmetics.command.subcommands.SubCommandGive;
import be.isach.ultracosmetics.command.subcommands.SubCommandMenu;
import be.isach.ultracosmetics.command.subcommands.SubCommandMigrate;
import be.isach.ultracosmetics.command.subcommands.SubCommandReload;
import be.isach.ultracosmetics.command.subcommands.SubCommandReward;
import be.isach.ultracosmetics.command.subcommands.SubCommandSelfView;
import be.isach.ultracosmetics.command.subcommands.SubCommandToggle;
import be.isach.ultracosmetics.command.subcommands.SubCommandTreasure;
import be.isach.ultracosmetics.command.subcommands.SubCommandTreasureNotification;
import be.isach.ultracosmetics.command.subcommands.SubCommandTroubleshoot;
import be.isach.ultracosmetics.command.subcommands.SubCommandUpdate;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Problem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor {
    private final List<SubCommand> commands = new ArrayList<SubCommand>();
    private final UltraCosmetics ultraCosmetics;

    public CommandManager(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        PluginCommand cmd = ultraCosmetics.getCommand("ultracosmetics");
        cmd.setExecutor((CommandExecutor)this);
        cmd.setTabCompleter((TabCompleter)new UCTabCompleter(ultraCosmetics));
        this.registerCommands();
    }

    public void registerCommand(SubCommand meCommand) {
        this.commands.add(meCommand);
    }

    public void showHelp(CommandSender sender, int page) {
        ArrayList available = new ArrayList();
        this.commands.stream().filter(c -> sender.hasPermission(c.getPermission())).forEach(available::add);
        if (available.size() < 1) {
            sender.sendMessage(MessageManager.getMessage("No-Permission"));
            return;
        }
        sender.sendMessage("");
        sender.sendMessage(ChatColor.WHITE + "" + ChatColor.BOLD + "UltraCosmetics Help (/uc <page>) " + ChatColor.DARK_GRAY + "" + ChatColor.BOLD + "(" + page + "/" + this.getMaxPages(available.size()) + ")");
        int from = 8 * (page - 1);
        int to = 8 * page;
        for (int i = from; i < to && i < available.size(); ++i) {
            SubCommand sub = (SubCommand)available.get(i);
            sender.sendMessage(ChatColor.DARK_GRAY + "|  " + ChatColor.GRAY + sub.getUsage() + ChatColor.WHITE + " " + ChatColor.ITALIC + sub.getDescription());
        }
    }

    private int getMaxPages(int commands) {
        int max = 8;
        return (commands - 1) / max + 1;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Set<Problem> problems = this.ultraCosmetics.getSevereProblems();
        if (problems.size() > 0) {
            sender.sendMessage(ChatColor.RED + "Plugin is currently disabled because:");
            problems.forEach(p -> sender.sendMessage(ChatColor.RED + p.getDescription()));
            SubCommandTroubleshoot.sendSupportMessage(sender);
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender, 1);
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("help")) {
                this.showHelp(sender, 1);
                return true;
            }
            if (MathUtils.isInteger(args[0])) {
                this.showHelp(sender, Integer.parseInt(args[0]));
                return true;
            }
        } else if (args.length == 2 && args[0].equalsIgnoreCase("help") && MathUtils.isInteger(args[1])) {
            this.showHelp(sender, Integer.parseInt(args[1]));
            return true;
        }
        for (SubCommand meCommand : this.commands) {
            if (!meCommand.is(args[0])) continue;
            if (!sender.hasPermission(meCommand.getPermission())) {
                sender.sendMessage(MessageManager.getMessage("No-Permission"));
                return true;
            }
            if (sender instanceof Player) {
                meCommand.onExePlayer((Player)sender, args);
            } else {
                meCommand.onExeAnyone(sender, args);
            }
            return true;
        }
        this.showHelp(sender, 1);
        return true;
    }

    public List<SubCommand> getCommands() {
        return this.commands;
    }

    public void registerCommands() {
        this.registerCommand(new SubCommandGadgets(this.ultraCosmetics));
        this.registerCommand(new SubCommandSelfView(this.ultraCosmetics));
        this.registerCommand(new SubCommandMenu(this.ultraCosmetics));
        this.registerCommand(new SubCommandGive(this.ultraCosmetics));
        this.registerCommand(new SubCommandToggle(this.ultraCosmetics));
        this.registerCommand(new SubCommandClear(this.ultraCosmetics));
        this.registerCommand(new SubCommandTreasure(this.ultraCosmetics));
        this.registerCommand(new SubCommandTreasureNotification(this.ultraCosmetics));
        this.registerCommand(new SubCommandMigrate(this.ultraCosmetics));
        this.registerCommand(new SubCommandReward(this.ultraCosmetics));
        this.registerCommand(new SubCommandReload(this.ultraCosmetics));
        this.registerCommand(new SubCommandUpdate(this.ultraCosmetics));
        this.registerCommand(new SubCommandTroubleshoot(this.ultraCosmetics));
    }
}

