/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?:\\d+\\.)+\\d+");
    private final String version;
    private final String versionString;

    public final String get() {
        return this.version;
    }

    public Version(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Could not parse version string: '" + version + "'");
        }
        this.version = matcher.group();
        this.versionString = version;
    }

    @Override
    public int compareTo(Version otherVersion) {
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = otherVersion.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
            int cmp = Integer.compare(thisPart, thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0);
            if (cmp == 0) continue;
            return cmp;
        }
        return Boolean.compare(this.isRelease(), otherVersion.isRelease());
    }

    public boolean isDev() {
        return this.versionString.toLowerCase().contains("dev");
    }

    public boolean isRelease() {
        return !this.isDev();
    }

    public boolean equals(Object that) {
        return this == that || that != null && this.getClass() == that.getClass() && this.compareTo((Version)that) == 0;
    }

    public int hashCode() {
        return this.version.hashCode();
    }
}

