/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.util.Problem;
import be.isach.ultracosmetics.util.ServerVersion;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.version.VersionManager;
import java.lang.reflect.Method;
import java.util.StringJoiner;
import org.bukkit.Bukkit;
import org.bukkit.UnsafeValues;

public class UltraCosmeticsData {
    private static UltraCosmeticsData instance;
    private boolean customCommandBackArrow;
    private String customBackMenuCommand;
    private boolean ammoEnabled;
    private boolean fileStorage = true;
    private boolean treasureChests;
    private boolean moneyTreasureLoot;
    private boolean cooldownInBar;
    private boolean closeAfterSelect;
    private boolean placeHolderColor;
    private String language;
    private ServerVersion serverVersion;
    private VersionManager versionManager;
    private UltraCosmetics ultraCosmetics;
    private boolean cosmeticsProfilesEnabled;

    public UltraCosmeticsData(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    public static UltraCosmeticsData get() {
        return instance;
    }

    public static void init(UltraCosmetics ultraCosmetics) {
        instance = new UltraCosmeticsData(ultraCosmetics);
    }

    protected void checkTreasureChests() {
        this.moneyTreasureLoot = this.ultraCosmetics.getEconomyHandler().isUsingEconomy() && SettingsManager.getConfig().getBoolean("TreasureChests.Loots.Money.Enabled");
        this.treasureChests = SettingsManager.getConfig().getBoolean("TreasureChests.Enabled");
    }

    protected boolean initModule() {
        SmartLogger logger = this.ultraCosmetics.getSmartLogger();
        logger.write("Initializing module " + (Object)((Object)this.serverVersion));
        if (!this.checkMappingsVersion(this.serverVersion)) {
            logger.write(SmartLogger.LogLevel.WARNING, "!!!!!!!!!!!!!!!!!!!!!!!!!!!! HEY YOU !!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            logger.write(SmartLogger.LogLevel.WARNING, "Server internals seem to have changed since this build was created.");
            logger.write(SmartLogger.LogLevel.WARNING, "Please check for a server update and an UltraCosmetics update.");
            logger.write(SmartLogger.LogLevel.WARNING, "UltraCosmetics will continue running but you will likely experience issues!");
            logger.write(SmartLogger.LogLevel.WARNING, "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.ultraCosmetics.addProblem(Problem.BAD_MAPPINGS_VERSION);
        }
        this.versionManager = new VersionManager(this.serverVersion);
        try {
            this.versionManager.load();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            logger.write("No module found for " + (Object)((Object)this.serverVersion) + "! UC will now be disabled.");
            this.ultraCosmetics.addProblem(Problem.NMS_LOAD_FAILURE);
            return false;
        }
        if (this.versionManager.getModule().enable()) {
            logger.write("Module initialized");
            return true;
        }
        logger.write(SmartLogger.LogLevel.ERROR, "Failed to start NMS module, UC will now be disabled.");
        this.ultraCosmetics.addProblem(Problem.NMS_LOAD_FAILURE);
        return false;
    }

    protected Problem checkServerVersion() {
        String mcVersion;
        String versionString = Bukkit.getServer().getClass().getPackage().getName();
        try {
            mcVersion = versionString.split("\\.")[3];
            mcVersion = mcVersion.substring(0, mcVersion.lastIndexOf(95));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Unable to determine server version. Please report this error.");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Version string: " + versionString);
            return Problem.UNKNOWN_MC_VERSION;
        }
        ServerVersion serverVersion = null;
        try {
            serverVersion = ServerVersion.valueOf(mcVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (serverVersion == null || !serverVersion.isNmsSupported()) {
            this.ultraCosmetics.getSmartLogger().write("This NMS version isn't supported. (" + mcVersion + ")!");
            StringJoiner sj = new StringJoiner(", ");
            for (ServerVersion version : ServerVersion.values()) {
                if (!version.isNmsSupported() || version == ServerVersion.latest()) continue;
                sj.add(version.getName());
            }
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "----------------------------");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "ULTRACOSMETICS CAN ONLY RUN ON " + sj.toString() + ", OR " + ServerVersion.latest().getName() + "!");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "");
            this.ultraCosmetics.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "----------------------------");
            return Problem.BAD_MC_VERSION;
        }
        this.setServerVersion(serverVersion);
        return null;
    }

    protected boolean checkMappingsVersion(ServerVersion version) {
        String currentMappingsVersion = null;
        UnsafeValues magicNumbers = Bukkit.getUnsafe();
        Class<?> magicNumbersClass = magicNumbers.getClass();
        try {
            Method mappingsVersionMethod = magicNumbersClass.getDeclaredMethod("getMappingsVersion", new Class[0]);
            currentMappingsVersion = (String)mappingsVersionMethod.invoke((Object)magicNumbers, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (currentMappingsVersion == null) {
            return version.getMappingsVersion() == null;
        }
        return currentMappingsVersion.equals(version.getMappingsVersion());
    }

    public void initConfigFields() {
        this.fileStorage = !SettingsManager.getConfig().getBoolean("MySQL.Enabled");
        this.placeHolderColor = SettingsManager.getConfig().getBoolean("Chat-Cosmetic-PlaceHolder-Color");
        this.ammoEnabled = SettingsManager.getConfig().getBoolean("Ammo-System-For-Gadgets.Enabled");
        this.cooldownInBar = SettingsManager.getConfig().getBoolean("Categories.Gadgets.Cooldown-In-ActionBar");
        this.customCommandBackArrow = this.ultraCosmetics.getConfig().getBoolean("Categories.Back-To-Main-Menu-Custom-Command.Enabled");
        this.customBackMenuCommand = this.ultraCosmetics.getConfig().getString("Categories.Back-To-Main-Menu-Custom-Command.Command").replace("/", "");
        this.closeAfterSelect = this.ultraCosmetics.getConfig().getBoolean("Categories.Close-GUI-After-Select");
        this.cosmeticsProfilesEnabled = this.ultraCosmetics.getConfig().getBoolean("Auto-Equip-Cosmetics");
        this.language = SettingsManager.getConfig().getString("Language");
    }

    public boolean isAmmoEnabled() {
        return this.ammoEnabled;
    }

    public boolean shouldCloseAfterSelect() {
        return this.closeAfterSelect;
    }

    public boolean displaysCooldownInBar() {
        return this.cooldownInBar;
    }

    public boolean usingCustomCommandBackArrow() {
        return this.customCommandBackArrow;
    }

    public boolean usingFileStorage() {
        return this.fileStorage;
    }

    public boolean useMoneyTreasureLoot() {
        return this.moneyTreasureLoot;
    }

    public boolean arePlaceholdersColored() {
        return this.placeHolderColor;
    }

    public boolean areTreasureChestsEnabled() {
        return this.treasureChests;
    }

    public String getCustomBackMenuCommand() {
        return this.customBackMenuCommand;
    }

    public String getLanguage() {
        return this.language;
    }

    public VersionManager getVersionManager() {
        return this.versionManager;
    }

    public ServerVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public UltraCosmetics getPlugin() {
        return this.ultraCosmetics;
    }

    public boolean areCosmeticsProfilesEnabled() {
        return this.cosmeticsProfilesEnabled;
    }

    public void setFileStorage(boolean fileStorage) {
        this.fileStorage = fileStorage;
    }
}

