/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics;

import be.isach.ultracosmetics.CosmeticManager;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.CommandManager;
import be.isach.ultracosmetics.config.AutoCommentConfiguration;
import be.isach.ultracosmetics.config.CustomConfiguration;
import be.isach.ultracosmetics.config.ManualCommentConfiguration;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.config.TreasureManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.economy.EconomyHandler;
import be.isach.ultracosmetics.listeners.Listener113;
import be.isach.ultracosmetics.listeners.Listener19;
import be.isach.ultracosmetics.listeners.MainListener;
import be.isach.ultracosmetics.listeners.PlayerListener;
import be.isach.ultracosmetics.listeners.PriorityListener;
import be.isach.ultracosmetics.menu.Menus;
import be.isach.ultracosmetics.mysql.MySqlConnectionManager;
import be.isach.ultracosmetics.permissions.LuckPermsHook;
import be.isach.ultracosmetics.permissions.PermissionCommand;
import be.isach.ultracosmetics.permissions.PermissionProvider;
import be.isach.ultracosmetics.placeholderapi.PlaceholderHook;
import be.isach.ultracosmetics.player.UltraPlayerManager;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.run.InvalidWorldChecker;
import be.isach.ultracosmetics.run.MovingChecker;
import be.isach.ultracosmetics.shaded.metrics.bukkit.Metrics;
import be.isach.ultracosmetics.shaded.metrics.charts.DrilldownPie;
import be.isach.ultracosmetics.shaded.metrics.charts.SimplePie;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.treasurechests.TreasureChestManager;
import be.isach.ultracosmetics.util.ArmorStandManager;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.PermissionPrinter;
import be.isach.ultracosmetics.util.Problem;
import be.isach.ultracosmetics.util.ServerVersion;
import be.isach.ultracosmetics.util.SmartLogger;
import be.isach.ultracosmetics.util.UpdateManager;
import be.isach.ultracosmetics.version.VersionManager;
import be.isach.ultracosmetics.worldguard.CosmeticRegionState;
import be.isach.ultracosmetics.worldguard.WorldGuardManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.libraryaddict.disguise.DisguiseConfig;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class UltraCosmetics
extends JavaPlugin {
    private CommandManager commandManager;
    private CustomConfiguration config;
    private File file;
    private UltraPlayerManager playerManager;
    private SmartLogger smartLogger;
    private MySqlConnectionManager mySqlConnectionManager;
    private UpdateManager updateChecker;
    private TreasureChestManager treasureChestManager;
    private Menus menus;
    private ArmorStandManager armorStandManager;
    private EconomyHandler economyHandler;
    private PermissionProvider permissionProvider;
    private WorldGuardManager worldGuardManager = new WorldGuardManager();
    private boolean legacyMessagePrinted = false;
    private boolean enableFinished = false;
    private Set<Problem> activeProblems = new HashSet<Problem>();

    public void onLoad() {
        this.smartLogger = new SmartLogger(this.getLogger());
        UltraCosmeticsData.init(this);
        Problem problem = UltraCosmeticsData.get().checkServerVersion();
        if (problem != null) {
            this.activeProblems.add(problem);
            return;
        }
        boolean worldGuardIntegration = super.getConfig().getBoolean("WorldGuard-Integration", true);
        if (worldGuardIntegration && this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuardManager.register(this);
        }
    }

    public void onEnable() {
        this.commandManager = new CommandManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new PriorityListener(this), (Plugin)this);
        if (!this.setUpConfig()) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to load config.yml, shutting down to protect data.");
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Please run config.yml through a YAML checker site.");
            this.activeProblems.add(Problem.BAD_CONFIG);
            return;
        }
        if (SettingsManager.getConfig().getBoolean("Check-For-Updates")) {
            this.getSmartLogger().write("Checking for update...");
            this.updateChecker = new UpdateManager(this);
            this.updateChecker.runTaskAsynchronously((Plugin)this);
        }
        if (UltraCosmeticsData.get().getServerVersion() == null) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Plugin load has failed, please check earlier in the log for details.");
            return;
        }
        UltraCosmeticsData.get().initConfigFields();
        String langFileName = "messages_" + UltraCosmeticsData.get().getLanguage() + ".yml";
        File langFile = new File(this.getDataFolder(), langFileName);
        if (!langFile.exists()) {
            try {
                int len;
                InputStream in = this.getResource("messages/" + langFileName);
                FileOutputStream out = new FileOutputStream(langFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
            catch (IOException e) {
                this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to copy " + langFileName);
            }
        }
        this.playerManager = new UltraPlayerManager(this);
        this.getSmartLogger().write("-------------------------------------------------------------------");
        this.getSmartLogger().write("UltraCosmetics v" + this.getDescription().getVersion() + " is loading... (server: " + UltraCosmeticsData.get().getServerVersion().getName() + ")");
        this.getSmartLogger().write("Thanks for downloading it!");
        this.getSmartLogger().write("Plugin by iSach.");
        this.getSmartLogger().write("Link: http://bit.ly/UltraCosmetics");
        if (!UltraCosmeticsData.get().initModule()) {
            return;
        }
        if (!MessageManager.success()) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to load messages.yml, shutting down to protect data.");
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Please run messages.yml through a YAML checker site.");
            this.activeProblems.add(Problem.BAD_MESSAGES);
            return;
        }
        new TreasureManager(this);
        this.registerListeners();
        new CosmeticManager(this).setupCosmeticsConfigs();
        if (SettingsManager.getConfig().getBoolean("Categories-Enabled." + Category.MORPHS.getConfigPath())) {
            if (!Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")) {
                this.getSmartLogger().write(new Object[0]);
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Morphs require Lib's Disguises, but it is not installed. Morphs will be disabled.");
            } else {
                try {
                    if (!DisguiseConfig.isTallSelfDisguises()) {
                        this.getSmartLogger().write(new Object[0]);
                        this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "You have TallSelfDisguises disabled in LibsDisguises's players.yml. Self view of morphs may not work as expected.");
                        this.activeProblems.add(Problem.TALL_DISGUISES_DISABLED);
                    }
                }
                catch (NoClassDefFoundError | NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.getSmartLogger().write(new Object[0]);
            new PlaceholderHook(this).register();
            this.getSmartLogger().write("Hooked into PlaceholderAPI");
        }
        this.setupWorldGuard();
        this.setupEconomy();
        this.setupPermissionProvider();
        if (!UltraCosmeticsData.get().usingFileStorage()) {
            this.getSmartLogger().write(new Object[0]);
            this.getSmartLogger().write("Connecting to MySQL database...");
            this.mySqlConnectionManager = new MySqlConnectionManager(this);
            if (this.mySqlConnectionManager.success()) {
                this.getSmartLogger().write("Connected to MySQL database.");
            } else {
                this.getSmartLogger().write("File storage will be used instead.");
                this.activeProblems.add(Problem.SQL_INIT_FAILURE);
            }
        }
        this.playerManager.initPlayers();
        new FallDamageManager().runTaskTimerAsynchronously((Plugin)this, 0L, 1L);
        new MovingChecker(this).runTaskTimerAsynchronously((Plugin)this, 0L, 1L);
        if (!this.config.getStringList("Enabled-Worlds").contains("*")) {
            new InvalidWorldChecker(this).runTaskTimerAsynchronously((Plugin)this, 0L, 5L);
        }
        this.armorStandManager = new ArmorStandManager(this);
        this.setupMetrics();
        this.reload();
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PermissionPrinter.printPermissions(this);
        this.getSmartLogger().write(new Object[0]);
        this.getSmartLogger().write("UltraCosmetics successfully finished loading and is now enabled!");
        this.getSmartLogger().write("-------------------------------------------------------------------");
        this.enableFinished = true;
    }

    public void reload() {
        this.menus = new Menus(this);
    }

    public void onDisable() {
        if (!this.enableFinished) {
            return;
        }
        if (this.mySqlConnectionManager != null && this.mySqlConnectionManager.success()) {
            this.mySqlConnectionManager.shutdown();
        }
        this.playerManager.dispose();
        UltraCosmeticsData.get().getVersionManager().getModule().disable();
    }

    private void registerListeners() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new MainListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntitySpawningManager(), (Plugin)this);
        if (UltraCosmeticsData.get().getServerVersion().offhandAvailable()) {
            pluginManager.registerEvents((Listener)new Listener19(this), (Plugin)this);
            if (VersionManager.IS_VERSION_1_13) {
                pluginManager.registerEvents((Listener)new Listener113(), (Plugin)this);
            }
        }
    }

    private void setupEconomy() {
        this.economyHandler = new EconomyHandler(this, this.getConfig().getString("Economy"));
        UltraCosmeticsData.get().checkTreasureChests();
    }

    private void setupPermissionProvider() {
        CustomConfiguration config = SettingsManager.getConfig();
        if (config.getString("TreasureChests.Permission-Add-Command", "").startsWith("!lp-api")) {
            if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
                this.permissionProvider = new LuckPermsHook(this);
                return;
            }
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Permission-Add-Command was set to '!lp-api' but LuckPerms is not present. Please change it manually.");
            config.set("TreasureChests.Permission-Add-Command", "say Please set Permission-Add-Command in UC config.yml");
        }
        if (config.getBoolean("TreasureChests.Enabled") && config.getString("TreasureChests.Permission-Add-Command", "say ").startsWith("say ")) {
            this.activeProblems.add(Problem.PERMISSION_COMMAND_NOT_SET);
        }
        this.permissionProvider = new PermissionCommand();
    }

    private void setupWorldGuard() {
        if (this.worldGuardManager != null) {
            if (!Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
                this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "WorldGuard is not enabled yet! Is WorldGuard up to date? Is another plugin interfering with the load order?");
                this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "WorldGuard support will be disabled.");
                this.activeProblems.add(Problem.WORLDGUARD_HOOK_FAILURE);
                this.worldGuardManager = null;
                return;
            }
            this.worldGuardManager.registerPhase2();
            this.getSmartLogger().write(new Object[0]);
            this.getSmartLogger().write("WorldGuard custom flags enabled");
        }
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this, 2629);
        ServerVersion sv = UltraCosmeticsData.get().getServerVersion();
        String nms = sv.isNmsSupported() ? sv.getNmsVersion() : "NMS-less " + (sv.isAtLeast(ServerVersion.v1_13) ? "flattening" : "legacy");
        String version = this.getDescription().getVersion();
        metrics.addCustomChart(new DrilldownPie("uc_by_mc", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(version, 1);
            map.put(nms, entry);
            return map;
        }));
        metrics.addCustomChart(new DrilldownPie("mc_by_uc", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(nms, 1);
            map.put(version, entry);
            return map;
        }));
        metrics.addCustomChart(new SimplePie("mysql_enabled", () -> this.getConfig().getBoolean("MySQL.Enabled") ? "true" : "false"));
    }

    private boolean setUpConfig() {
        String oldMysqlKey;
        ConfigurationSection oldSQL;
        ConfigurationSection section;
        String mode;
        this.file = new File(this.getDataFolder(), "config.yml");
        if (!this.file.exists()) {
            this.saveResource("config.yml", false);
        }
        if (!this.loadConfiguration(this.file)) {
            return false;
        }
        ArrayList<String> disabledCommands = new ArrayList<String>();
        disabledCommands.add("hat");
        this.config.addDefault("Disabled-Commands", disabledCommands, "List of commands that won't work when cosmetics are equipped.", "Command arguments are ignored, commands are blocked when base command matches.");
        ArrayList<String> enabledWorlds = new ArrayList<String>();
        enabledWorlds.add("*");
        this.config.addDefault("Enabled-Worlds", enabledWorlds, "List of the worlds where cosmetics are enabled!", "If list contains '*', all worlds will be allowed.");
        this.config.set("Disabled-Items", null);
        this.config.addDefault("Economy", "Vault");
        if (this.config.getInt("TreasureChests.Count") < 1 || this.config.getInt("TreasureChests.Count") > 4) {
            this.config.set("TreasureChests.Count", 4, "How many treasure chests should be opened per key? Min 1, max 4");
        }
        if (!((mode = this.config.getString("TreasureChests.Mode", "")).equalsIgnoreCase("structure") || mode.equalsIgnoreCase("simple") || mode.equalsIgnoreCase("both"))) {
            this.config.set("TreasureChests.Mode", "structure", "The treasure chest mode. Options:", "- structure: places blocks and chests (default)", "- simple: only gives <Count> cosmetics, no blocks are placed", "- both: players can choose either mode through the GUI");
        }
        if (this.config.isConfigurationSection("TreasureChests.Location")) {
            this.config.set("TreasureChests.Locations.Enabled", this.config.getBoolean("TreasureChests.Location.Enabled"));
            this.config.set("TreasureChests.Location.Enabled", null);
            section = this.config.getConfigurationSection("TreasureChests.Location");
            this.config.set("TreasureChests.Location", null);
            this.config.set("TreasureChests.Locations.default", section);
        }
        if (!this.config.isConfigurationSection("TreasureChests.Locations")) {
            section = this.config.createSection("TreasureChests.Locations.default");
            this.config.set("TreasureChests.Locations.default.Enabled", false, "Whether players should be moved to a certain", "location before opening a treasure chest.", "Does not override /uc treasure with position args.");
            this.config.set("TreasureChests.Location.default.X", 0, "The location players should be moved to.", "Block coordinates only, like 104, not 103.63", "To use the world the player is in, set World to 'none'");
            section.set("Y", (Object)63);
            section.set("Z", (Object)0);
            section.set("World", (Object)((World)Bukkit.getWorlds().get(0)).getName());
        }
        this.config.addDefault("TreasureChests.Locations.default.World", ((World)Bukkit.getWorlds().get(0)).getName());
        if (!this.config.isInt("TreasureChests.Loots.Money.Min")) {
            int min = 15;
            int max = this.config.getInt("TreasureChests.Loots.Money.Max");
            if (max < 5) {
                min = 0;
            } else if (max < 15) {
                min = 5;
            }
            this.config.set("TreasureChests.Loots.Money.Min", min);
        }
        if (!this.config.isConfigurationSection("TreasureChests.Loots.Gadgets")) {
            ConfigurationSection section2 = this.config.createSection("TreasureChests.Loots.Gadgets", "Chance of getting a GADGET", "This is different from ammo!");
            section2.set("Enabled", (Object)true);
            section2.set("Chance", (Object)20);
            section2.set("Message.enabled", (Object)false);
            section2.set("Message.message", (Object)"%prefix% &6&l%name% found gadget %gadget%");
        }
        if (!this.config.isConfigurationSection("TreasureChests.Loots.Suits")) {
            this.config.createSection("TreasureChests.Loots.Suits");
            this.config.set("TreasureChests.Loots.Suits.Enabled", true);
            this.config.set("TreasureChests.Loots.Suits.Chance", 10);
            this.config.set("TreasureChests.Loots.Suits.Message.enabled", false);
            this.config.set("TreasureChests.Loots.Suits.Message.message", "%prefix% &6&l%name% found suit part: %suitw%");
        }
        if (!this.config.isConfigurationSection("Categories.Suits")) {
            ConfigurationSection suits = this.config.createSection("Categories.Suits");
            suits.set("Main-Menu-Item", (Object)XMaterial.LEATHER_CHESTPLATE.parseMaterial().toString());
            suits.set("Go-Back-Arrow", (Object)true);
        }
        if (!this.config.isConfigurationSection("TreasureChests.Loots.Commands")) {
            ConfigurationSection section3 = this.config.createSection("TreasureChests.Loots.Commands.shoutout");
            section3.set("Name", (Object)"&d&lShoutout");
            section3.set("Material", (Object)"NETHER_STAR");
            section3.set("Enabled", (Object)false);
            section3.set("Chance", (Object)100);
            section3.set("Message.enabled", (Object)false);
            section3.set("Message.message", (Object)"%prefix% &6&l%name% found a rare shoutout!");
            section3.set("Cancel-If-Permission", (Object)"no");
            section3.set("Commands", Collections.singletonList("say %name% is awesome!"));
            section3 = this.config.createSection("TreasureChests.Loots.Commands.flower");
            section3.set("Name", (Object)"&e&lFlower");
            section3.set("Material", (Object)"YELLOW_FLOWER");
            section3.set("Enabled", (Object)false);
            section3.set("Chance", (Object)100);
            section3.set("Message.enabled", (Object)false);
            section3.set("Message.message", (Object)"%prefix% &6&l%name% found a flower!");
            section3.set("Cancel-If-Permission", (Object)"example.yellowflower");
            section3.set("Commands", Arrays.asList("give %name% yellow_flower 1", "lp user %name% permission set example.yellowflower true"));
        }
        if ((oldSQL = SettingsManager.getConfig().getConfigurationSection("Ammo-System-For-Gadgets.MySQL")) != null) {
            SettingsManager.getConfig().set("MySQL", oldSQL);
            SettingsManager.getConfig().set("Ammo-System-For-Gadgets.MySQL", null);
        }
        if (this.config.isString(oldMysqlKey = "Ammo-System-For-Gadgets.System")) {
            this.config.set("MySQL.Enabled", !this.config.getString(oldMysqlKey).equalsIgnoreCase("file"));
            this.config.set(oldMysqlKey, null);
        }
        this.config.addDefault("MySQL.Enabled", false);
        this.config.addDefault("MySQL.hostname", "localhost");
        this.config.addDefault("MySQL.username", "root");
        this.config.addDefault("MySQL.password", "password");
        this.config.addDefault("MySQL.port", "3306");
        this.config.addDefault("MySQL.database", "database");
        this.config.addDefault("MySQL.table", "UltraCosmeticsData");
        this.config.addDefault("Categories.Clear-Cosmetic-Item", XMaterial.REDSTONE_BLOCK.parseMaterial().toString(), "Item where user click to clear a cosmetic.");
        this.config.addDefault("Categories.Previous-Page-Item", XMaterial.ENDER_PEARL.parseMaterial().toString(), "Previous Page Item");
        this.config.addDefault("Categories.Next-Page-Item", XMaterial.ENDER_EYE.parseMaterial().toString(), "Next Page Item");
        this.config.addDefault("Categories.Back-Main-Menu-Item", XMaterial.ARROW.parseMaterial().toString(), "Back to Main Menu Item");
        this.config.addDefault("Categories.Self-View-Item.When-Enabled", XMaterial.ENDER_EYE.parseMaterial().toString(), "Item in Morphs Menu when Self View enabled.");
        this.config.addDefault("Categories.Self-View-Item.When-Disabled", XMaterial.ENDER_PEARL.parseMaterial().toString(), "Item in Morphs Menu when Self View disabled.");
        this.config.addDefault("Categories.Gadgets-Item.When-Enabled", XMaterial.LIGHT_GRAY_DYE.parseMaterial().toString(), "Item in Gadgets Menu when Gadgets enabled.");
        this.config.addDefault("Categories.Gadgets-Item.When-Disabled", XMaterial.GRAY_DYE.parseMaterial().toString(), "Item in Gadgets Menu when Gadgets disabled.");
        this.config.addDefault("Categories.Rename-Pet-Item", XMaterial.NAME_TAG.parseMaterial().toString(), "Item in Pets Menu to rename current pet.");
        this.config.addDefault("Categories.Close-GUI-After-Select", true, "Should GUI close after selecting a cosmetic?");
        this.config.addDefault("No-Permission.Custom-Item.Lore", Arrays.asList("", "&c&lYou do not have permission for this!", ""));
        this.config.addDefault("No-Permission.Allow-Purchase", false, "Requires Dont-Show-Item to be false");
        this.config.addDefault("Categories.Back-To-Main-Menu-Custom-Command.Enabled", false);
        this.config.addDefault("Categories.Back-To-Main-Menu-Custom-Command.Command", "cc open custommenu.yml {player}");
        this.config.addDefault("Categories-Enabled.Suits", true, "Do you want to enable Suits category?");
        this.config.addDefault("Categories.Gadgets.Cooldown-In-ActionBar", true, "You wanna show the cooldown of", "current gadget in action bar?");
        if (this.config.contains("Auto-Equip-Cosmetics.enabled")) {
            this.config.set("Auto-Equip-Cosmetics.enabled", null);
            this.config.set("Auto-Equip-Cosmetics.is-enabled", false);
        }
        if (this.config.isBoolean("Auto-Equip-Cosmetics.is-enabled")) {
            boolean autoEquip = this.config.getBoolean("Auto-Equip-Cosmetics.is-enabled");
            this.config.set("Auto-Equip-Cosmetics", autoEquip, "Allows for players to auto-equip on join cosmetics they had before disconnecting.", "Supports both flatfile and SQL, choosing SQL when possible.");
        }
        if (!this.config.contains("allow-damage-to-players-on-mounts")) {
            this.config.set("allow-damage-to-players-on-mounts", false);
        }
        this.config.addDefault("WorldGuard-Integration", true, "Whether WorldGuard should be hooked when loading UC", "Disable this if UC has trouble loading WorldGuard");
        this.config.addDefault("Pets-Are-Silent", false, "Are pets prevented from making sounds?");
        this.config.addDefault("Gadgets-Are-Silent", false, "Are gadgets prevented from making sounds?");
        if (this.config.isBoolean("Menu-Item.Give-On-Join")) {
            boolean enabled = this.config.getBoolean("Menu-Item.Give-On-Join");
            this.config.set("Menu-Item.Enabled", enabled);
            this.config.set("Menu-Item.Give-On-Join", null);
            this.config.set("Menu-Item.Give-On-Respawn", null);
        }
        this.config.addDefault("Menu-Item.Custom-Model-Data", 0, "Custom model data for the menu item. Only supported on MC >= 1.14.4 (when it was added)");
        this.config.addDefault("Menu-Item.Open-Menu-On-Inventory-Click", false, "Whether to open cosmetics menu when the menu item is clicked from the player's inventory");
        this.config.set("Menu-Item.Data", null);
        this.config.addDefault("Menu-Item.Lore", "&aRight-click with this\n&ato open the menu", "Lore to apply to the menu item. Set to '' to disable");
        this.config.addDefault("Auto-Equip-Cosmetics", true, "Allows for players to auto-equip on join cosmetics they had before disconnecting.", "Supports both flatfile and SQL, choosing SQL when possible.");
        this.config.addDefault("Area-Debug", false, "When enabled, prints why area checks failed to the console");
        ArrayList airMaterials = new ArrayList();
        Arrays.asList(XMaterial.AIR, XMaterial.CAVE_AIR, XMaterial.VOID_AIR, XMaterial.LIGHT).forEach(k -> airMaterials.add(k.name()));
        this.config.addDefault("Air-Materials", airMaterials, "Materials that are treated as air. Changing these is not recommended.");
        this.config.addDefault("Auto-Update", false, "Whether UltraCosmetics should automatically download and install new versions.", "Requires Check-For-Updates to be enabled.");
        this.config.addDefault("Prevent-Cosmetics-In-Vanish", false, "Whether UltraCosmetics should prevent vanished players from using cosmetics.", "Works with any vanish plugin that uses 'vanished' metdata.");
        this.config.addDefault("Max-Entity-Spawns-Per-Tick", 10, "Limits the number of entities that can be spawned by a single gadget per tick (default 10.)", "Set to 0 to spawn all entities instantly.");
        String pathPrefix = "messages/messages_";
        ArrayList<String> supportedLanguages = new ArrayList<String>();
        try {
            ZipEntry e;
            URL jar = this.getFile().toURI().toURL();
            ZipInputStream zip = new ZipInputStream(jar.openStream());
            while ((e = zip.getNextEntry()) != null) {
                String path = e.getName();
                if (!path.startsWith(pathPrefix)) continue;
                supportedLanguages.add(path.substring(pathPrefix.length(), pathPrefix.length() + 2));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.config.set("Supported-Languages", supportedLanguages, "Languages supported by this version of UltraCosmetics.", "This is not a configurable list, just informative.");
        this.config.addDefault("Language", "en", "The language to use. Can be set to any language listed above.");
        this.upgradeIdsToMaterials();
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public UltraPlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public File getFile() {
        return super.getFile();
    }

    public File getConfigFile() {
        return this.file;
    }

    public Reader getFileReader(String path) {
        return this.getTextResource(path);
    }

    public CustomConfiguration getConfig() {
        return this.config;
    }

    public SmartLogger getSmartLogger() {
        return this.smartLogger;
    }

    public UpdateManager getUpdateChecker() {
        return this.updateChecker;
    }

    public TreasureChestManager getTreasureChestManager() {
        return this.treasureChestManager;
    }

    public Menus getMenus() {
        return this.menus;
    }

    public MySqlConnectionManager getMySqlConnectionManager() {
        return this.mySqlConnectionManager;
    }

    public ArmorStandManager getArmorStandManager() {
        return this.armorStandManager;
    }

    public EconomyHandler getEconomyHandler() {
        return this.economyHandler;
    }

    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }

    public WorldGuardManager getFlagManager() {
        return this.worldGuardManager;
    }

    public boolean worldGuardHooked() {
        return this.worldGuardManager != null;
    }

    public boolean areCosmeticsAllowedInRegion(Player player, Category category) {
        return !this.worldGuardHooked() || this.worldGuardManager.areCosmeticsAllowedHere(player, category);
    }

    public boolean areChestsAllowedInRegion(Player player) {
        return !this.worldGuardHooked() || this.worldGuardManager.areChestsAllowedHere(player);
    }

    public boolean arePlayersAffectedInRegion(Player target) {
        return !this.worldGuardHooked() || this.worldGuardManager.canAffectPlayersHere(target);
    }

    public CosmeticRegionState cosmeticRegionState(Player player, Category category) {
        if (!this.worldGuardHooked()) {
            return CosmeticRegionState.ALLOWED;
        }
        return this.worldGuardManager.allowedCosmeticsState(player, category);
    }

    public void forceRegionCheck(Player target) {
        if (!this.worldGuardHooked()) {
            return;
        }
        this.worldGuardManager.doCosmeticCheck(target, this);
    }

    public boolean loadConfiguration(File file) {
        try {
            ConfigurationSection.class.getDeclaredMethod("getComments", String.class);
            this.config = new AutoCommentConfiguration();
        }
        catch (NoSuchMethodException ignored) {
            this.config = new ManualCommentConfiguration();
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return false;
        }
        try {
            this.config.load(file);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException | InvalidConfigurationException ex) {
            this.getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Cannot load " + file, ex);
            return false;
        }
        return true;
    }

    private void upgradeIdsToMaterials() {
        this.upgradeKeyToMaterial("Categories.Gadgets.Main-Menu-Item", "409:0", XMaterial.PRISMARINE_SHARD);
        this.upgradeKeyToMaterial("Categories.Particle-Effects.Main-Menu-Item", "399:0", XMaterial.NETHER_STAR);
        this.upgradeKeyToMaterial("Categories.Mounts.Main-Menu-Item", "329:0", XMaterial.SADDLE);
        this.upgradeKeyToMaterial("Categories.Pets.Main-Menu-Item", "352:0", XMaterial.BONE);
        this.upgradeKeyToMaterial("Categories.Morphs.Main-Menu-Item", "334:0", XMaterial.LEATHER);
        this.upgradeKeyToMaterial("Categories.Hats.Main-Menu-Item", "314:0", XMaterial.GOLDEN_HELMET);
        this.upgradeKeyToMaterial("Categories.Suits.Main-Menu-Item", "299:0", XMaterial.LEATHER_CHESTPLATE);
        this.upgradeKeyToMaterial("Categories.Clear-Cosmetic-Item", "152:0", XMaterial.REDSTONE_BLOCK);
        this.upgradeKeyToMaterial("Categories.Previous-Page-Item", "368:0", XMaterial.ENDER_PEARL);
        this.upgradeKeyToMaterial("Categories.Next-Page-Item", "381:0", XMaterial.ENDER_EYE);
        this.upgradeKeyToMaterial("Categories.Back-Main-Menu-Item", "262:0", XMaterial.ARROW);
        this.upgradeKeyToMaterial("Categories.Self-View-Item.When-Enabled", "381:0", XMaterial.ENDER_EYE);
        this.upgradeKeyToMaterial("Categories.Self-View-Item.When-Disabled", "368:0", XMaterial.ENDER_PEARL);
        this.upgradeKeyToMaterial("Categories.Gadgets-Item.When-Enabled", "351:10", XMaterial.LIGHT_GRAY_DYE);
        this.upgradeKeyToMaterial("Categories.Gadgets-Item.When-Disabled", "351:8", XMaterial.GRAY_DYE);
        this.upgradeKeyToMaterial("Categories.Rename-Pet-Item", "421:0", XMaterial.NAME_TAG);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.center-block", "169:0", XMaterial.SEA_LANTERN);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.around-center", "5:0", XMaterial.OAK_PLANKS);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.third-blocks", "5:1", XMaterial.SPRUCE_PLANKS);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.below-chests", "17:0", XMaterial.OAK_LOG);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Classic.barriers", "85:0", XMaterial.OAK_FENCE);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.center-block", "169:0", XMaterial.SEA_LANTERN);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.around-center", "159:11", XMaterial.BLUE_TERRACOTTA);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.third-blocks", "155:0", XMaterial.WHITE_TERRACOTTA);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.below-chests", "159:11", XMaterial.BLUE_TERRACOTTA);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Modern.barriers", "160:3", XMaterial.LIGHT_BLUE_STAINED_GLASS_PANE);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.center-block", "89:0", XMaterial.GLOWSTONE);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.around-center", "88:0", XMaterial.SOUL_SAND);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.third-blocks", "87:0", XMaterial.NETHERRACK);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.below-chests", "112:0", XMaterial.NETHER_BRICKS);
        this.upgradeKeyToMaterial("TreasureChests.Designs.Nether.barriers", "113:0", XMaterial.NETHER_BRICK_FENCE);
        this.upgradeKeyToMaterial("Fill-Blank-Slots-With-Item.Item", "160:15", XMaterial.BLACK_STAINED_GLASS_PANE);
    }

    private void upgradeKeyToMaterial(String key, String oldValue, XMaterial newValue) {
        if (oldValue.equals(this.config.getString(key))) {
            if (!this.legacyMessagePrinted) {
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "You seem to still have numeric IDs in your config, which UC no longer supports.");
                this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "I'll attempt to upgrade them, but only if the values haven't been touched.");
                this.legacyMessagePrinted = true;
            }
            this.config.set(key, newValue.toString());
            this.getSmartLogger().write(SmartLogger.LogLevel.INFO, "Successfully upgraded key '" + key + "' from '" + oldValue + "' to '" + (Object)((Object)newValue) + "'!");
        } else if (this.legacyMessagePrinted) {
            this.getSmartLogger().write(SmartLogger.LogLevel.WARNING, "Couldn't upgrade key '" + key + "' because it has been changed. Please upgrade it manually.");
        }
    }

    public void addProblem(Problem problem) {
        this.activeProblems.add(problem);
    }

    public void removeProblem(Problem problem) {
        this.activeProblems.remove((Object)problem);
    }

    public Set<Problem> getProblems() {
        return this.activeProblems;
    }

    public Set<Problem> getSevereProblems() {
        HashSet<Problem> severe = new HashSet<Problem>(this.activeProblems);
        severe.removeIf(p -> !p.isSevere());
        return severe;
    }
}

