/*
 * Decompiled with CFR 0.152.
 */
package me.boxfinate.events;

import me.boxfinate.UltimateChatFormat;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AsyncPlayerChat
implements Listener {
    private UltimateChatFormat plugin;

    public AsyncPlayerChat(UltimateChatFormat plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent e) {
        e.setCancelled(true);
        Player player = e.getPlayer();
        String message = e.getMessage();
        String format = this.plugin.getConfig().getString("chat-format");
        if (this.plugin.isPapiEnabled()) {
            format = PlaceholderAPI.setPlaceholders((Player)player, (String)format);
        }
        for (Player op : this.plugin.getServer().getOnlinePlayers()) {
            String name = op.getName().toUpperCase();
            String upperMessage = message.toUpperCase();
            if (upperMessage.contains(name) && player.hasPermission("ucf.ping")) {
                int index = upperMessage.indexOf(name);
                String noNameMessage = String.valueOf(String.valueOf(message.substring(0, index))) + message.substring(index + name.length(), message.length());
                name = this.setPingFormat(op.getName());
                String changedMessage = String.valueOf(String.valueOf(noNameMessage.substring(0, index))) + name + noNameMessage.substring(index);
                this.sendMessage(op, player, format, changedMessage, true);
                continue;
            }
            this.sendMessage(op, player, format, message, false);
        }
    }

    private String setPingFormat(String name) {
        name = this.plugin.getConfig().getString("ping-format").replaceFirst("%name%", name).replaceAll("&", "\u00a7");
        return name;
    }

    private void sendMessage(Player other, Player player, String format, String message, boolean isPing) {
        other.sendMessage(format.replaceFirst("%prefix%", this.plugin.GetChat().getPlayerPrefix(player)).replaceFirst("%name%", player.getName()).replaceFirst("%displayname%", player.getDisplayName()).replaceFirst("%suffix%", this.plugin.GetChat().getPlayerSuffix(player)).replaceAll("&", "\u00a7").replaceFirst("%message%", message.replaceAll("\\$", "\\\\\\$")));
        if (isPing) {
            if (this.plugin.getConfig().getString("ping-sound") == "none" || this.plugin.getConfig().getString("ping-sound") == "" || this.plugin.getConfig().getString("ping-sound") == null) {
                return;
            }
            other.playSound(other.getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("ping-sound").toUpperCase()), 10.0f, 1.0f);
        }
    }
}

