/*
 * Decompiled with CFR 0.152.
 */
package me.pulsi_.ultimateautomessage.utils;

import me.pulsi_.ultimateautomessage.utils.DefaultFontInfo;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class Methods {
    private static final int CENTER_PX = 154;

    public static void playReloadSound(Player p) {
        Sound sound;
        try {
            sound = Sound.ENTITY_ARROW_SHOOT;
        }
        catch (NoSuchFieldError e) {
            sound = Sound.valueOf((String)"SHOOT_ARROW");
        }
        p.playSound(p.getLocation(), sound, 10.0f, 1.0f);
    }

    public static void sendCenteredMessage(Player player, String message) {
        if (message == null || message.equals("")) {
            player.sendMessage("");
            return;
        }
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char letter : message.toCharArray()) {
            if (letter == '&') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                isBold = letter == 'l' || letter == 'L';
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(letter);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        player.sendMessage(sb + message);
    }
}

