/*
 * Decompiled with CFR 0.152.
 */
package me.pulsi_.ultimateautomessage.mechanics;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.pulsi_.ultimateautomessage.UltimateAutoMessage;
import me.pulsi_.ultimateautomessage.utils.ChatUtils;
import me.pulsi_.ultimateautomessage.utils.Methods;
import me.pulsi_.ultimateautomessage.values.Values;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AutoMessageMechanics {
    public static List<List<String>> autoMessagesList;
    public static BukkitTask autoMessageTask;
    private static int count;

    public static void processAutoMessage() {
        autoMessageTask = Bukkit.getScheduler().runTaskTimer((Plugin)UltimateAutoMessage.getInstance(), () -> {
            if (Values.isRandomMode()) {
                int randomInt = new Random().nextInt(autoMessagesList.size());
                AutoMessageMechanics.sendMessage(randomInt);
            } else {
                if (AutoMessageMechanics.isAutoMessageListEnded(count)) {
                    count = 0;
                }
                AutoMessageMechanics.sendMessage(count);
                ++count;
            }
        }, 0L, (long)Values.getMessagesDelay() * 20L);
    }

    public static void restartAutoMessageTask() {
        if (autoMessageTask != null) {
            autoMessageTask.cancel();
        }
        count = 0;
        AutoMessageMechanics.processAutoMessage();
    }

    public static void loadMessages() {
        autoMessagesList = new ArrayList<List<String>>();
        FileConfiguration config = UltimateAutoMessage.getInstance().getConfig();
        ConfigurationSection section = config.getConfigurationSection("Messages");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            List singleMessageList = config.getStringList("Messages." + key);
            autoMessagesList.add(singleMessageList);
        }
    }

    private static void sendMessage(int count) {
        List<String> autoMessage = autoMessagesList.get(count);
        for (Player p : Bukkit.getOnlinePlayers()) {
            for (String message : autoMessage) {
                String msg = ChatUtils.color(message);
                if (!message.startsWith("[CENTRE]") || !message.endsWith("[CENTRE]")) {
                    p.sendMessage(msg);
                    if (!Values.isMessagesToConsole()) continue;
                    ChatUtils.log(msg);
                    continue;
                }
                Methods.sendCenteredMessage(p, msg.replace("[CENTRE]", ""));
                if (!Values.isMessagesToConsole()) continue;
                ChatUtils.log(msg.replace("[CENTRE]", ""));
            }
        }
    }

    private static boolean isAutoMessageListEnded(int count) {
        return count >= autoMessagesList.size();
    }

    static {
        count = 0;
    }
}

