/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.api.HelpResources;
import twitter4j.conf.Configuration;

public class LanguageJSONImpl
implements HelpResources.Language {
    private String name;
    private String code;
    private String status;

    LanguageJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            this.name = json.getString("name");
            this.code = json.getString("code");
            this.status = json.getString("status");
        }
        catch (JSONException jsone) {
            throw new TwitterException(String.valueOf(jsone.getMessage()) + ":" + json.toString(), jsone);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    static ResponseList<HelpResources.Language> createLanguageList(HttpResponse res, Configuration conf) throws TwitterException {
        return LanguageJSONImpl.createLanguageList(res.asJSONArray(), res, conf);
    }

    static ResponseList<HelpResources.Language> createLanguageList(JSONArray list, HttpResponse res, Configuration conf) throws TwitterException {
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
        }
        try {
            int size = list.length();
            ResponseListImpl<HelpResources.Language> languages = new ResponseListImpl<HelpResources.Language>(size, res);
            int i = 0;
            while (i < size) {
                JSONObject json = list.getJSONObject(i);
                LanguageJSONImpl language = new LanguageJSONImpl(json);
                languages.add(language);
                if (conf.isJSONStoreEnabled()) {
                    TwitterObjectFactory.registerJSONObject(language, json);
                }
                ++i;
            }
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.registerJSONObject(languages, list);
            }
            return languages;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }
}

