/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;

final class ExceptionDiagnosis
implements Serializable {
    private static final long serialVersionUID = 8501009773274399369L;
    private int stackLineHash;
    private int lineNumberHash;
    private String hexString = "";

    ExceptionDiagnosis(Throwable th) {
        this(th, new String[0]);
    }

    ExceptionDiagnosis(Throwable th, String[] inclusionFilter) {
        Throwable th1 = th;
        StackTraceElement[] stackTrace = th.getStackTrace();
        this.stackLineHash = 0;
        this.lineNumberHash = 0;
        int i = stackTrace.length - 1;
        while (i >= 0) {
            StackTraceElement line = stackTrace[i];
            String[] stringArray = inclusionFilter;
            int n = inclusionFilter.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (line.getClassName().startsWith(filter)) {
                    int hash = line.getClassName().hashCode() + line.getMethodName().hashCode();
                    this.stackLineHash = 31 * this.stackLineHash + hash;
                    this.lineNumberHash = 31 * this.lineNumberHash + line.getLineNumber();
                    break;
                }
                ++n2;
            }
            --i;
        }
        this.hexString = String.valueOf(this.hexString) + this.toHexString(this.stackLineHash) + "-" + this.toHexString(this.lineNumberHash);
        if (th.getCause() != null) {
            this.hexString = String.valueOf(this.hexString) + " " + new ExceptionDiagnosis(th.getCause(), inclusionFilter).asHexString();
        }
    }

    int getStackLineHash() {
        return this.stackLineHash;
    }

    String getStackLineHashAsHex() {
        return this.toHexString(this.stackLineHash);
    }

    int getLineNumberHash() {
        return this.lineNumberHash;
    }

    String getLineNumberHashAsHex() {
        return this.toHexString(this.lineNumberHash);
    }

    String asHexString() {
        return this.hexString;
    }

    private String toHexString(int value) {
        String str = "0000000" + Integer.toHexString(value);
        return str.substring(str.length() - 8, str.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionDiagnosis that = (ExceptionDiagnosis)o;
        if (this.lineNumberHash != that.lineNumberHash) {
            return false;
        }
        return this.stackLineHash == that.stackLineHash;
    }

    public int hashCode() {
        int result = this.stackLineHash;
        result = 31 * result + this.lineNumberHash;
        return result;
    }

    public String toString() {
        return "ExceptionDiagnosis{stackLineHash=" + this.stackLineHash + ", lineNumberHash=" + this.lineNumberHash + '}';
    }
}

