/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Menu
implements Listener {
    private final Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a72\u00a7lManHunt");

    public Menu() {
        this.initializeItems();
    }

    public void initializeItems() {
        Player hunted = TwistedManhunt.getHunted();
        this.inv.setItem(1, this.createGuiItem(Material.COMPASS, "\u00a72Compass Distance : \u00a7l" + TwistedManhunt.showDistance(), "\u00a7aDoes the compass indicate the distance on use ?"));
        this.inv.setItem(2, this.createGuiItem(Material.COMPASS, "\u00a72Compass Timer : \u00a7l" + TwistedManhunt.hasTimer() + "\u00a72 second(s)", "\u00a7aTime between too right-click with the compass ?"));
        this.inv.setItem(4, this.createGuiItem(Material.OAK_SIGN, "\u00a74\u00a7l" + hunted.getDisplayName(), "\u00a7c(S)He's the Hunted you selected"));
        this.inv.setItem(6, this.createGuiItem(Material.DRAGON_HEAD, "\u00a72Win by the dragon : \u00a7l" + TwistedManhunt.KillDragonisWin(), "\u00a7aIf the hunters kill the dragon,", "\u00a7ais the win for them ?"));
        this.inv.setItem(7, this.createGuiItem(Material.RED_BED, "\u00a72Hunted respawn : \u00a7l" + TwistedManhunt.getMaxHuntedLives() + "\u00a72 lives", "\u00a7aHow many time the hunted can respawn before loosing ?"));
        boolean addedHearts = TwistedManhunt.getaddedHearts();
        if (addedHearts) {
            this.inv.setItem(20, this.createGlowingGuiItem(Material.SHIELD, "\u00a72Added Heart on Kill : \u00a7l" + addedHearts, "\u00a7aAdding hearth to the hunted every kill he does"));
            this.inv.setItem(29, this.createGuiItem(Material.SHIELD, "\u00a72Amount of heart : \u00a7l" + TwistedManhunt.getamountAddedHearts() + "\u00a72 heart(s)", "\u00a7aThe amount of heart added after each kill"));
        } else {
            this.inv.setItem(20, this.createGuiItem(Material.SHIELD, "\u00a72Added Heart on Kill : \u00a7l" + addedHearts, "\u00a7aAdding hearth to the hunted every kill he does"));
            this.inv.setItem(29, this.createGuiItem(Material.AIR, "n", new String[0]));
        }
        boolean rdmDrop = TwistedManhunt.rdmDrop();
        if (rdmDrop) {
            this.inv.setItem(22, this.createGlowingGuiItem(Material.GRASS_BLOCK, "\u00a72Random drop on break : \u00a7l" + rdmDrop, "\u00a7aDrop random stuff when you break blocks"));
            this.inv.setItem(31, this.createGuiItem(Material.GRASS_BLOCK, "\u00a72Randomness is consistent : \u00a7l" + TwistedManhunt.consistentRdmDrop(), "\u00a7aIf grass drops ice once, it will drop ice", "\u00a7auntil the end of the game"));
        } else {
            this.inv.setItem(22, this.createGuiItem(Material.GRASS_BLOCK, "\u00a72Random drop on break : \u00a7l" + rdmDrop, "\u00a7aDrop random stuff when you break blocks"));
            this.inv.setItem(31, this.createGuiItem(Material.AIR, "n", new String[0]));
        }
        boolean rdmPlaceSwap = TwistedManhunt.rdmPlaceSwap();
        if (rdmPlaceSwap) {
            this.inv.setItem(24, this.createGlowingGuiItem(Material.ENDER_PEARL, "\u00a72Swap : \u00a7l" + rdmPlaceSwap, "\u00a7aRegularly swap people"));
            this.inv.setItem(33, this.createGuiItem(Material.ENDER_PEARL, "\u00a72Swap time : \u00a7l" + TwistedManhunt.placeSwapTime() + "\u00a7a seconds", "\u00a7aTime between each swap", " ", "\u00a7a60 = 1 minute", "\u00a7a120 = 2 minutes", "\u00a7a300 = 5 minutes", "\u00a7a1800 = 30 minutes"));
        } else {
            this.inv.setItem(24, this.createGuiItem(Material.ENDER_PEARL, "\u00a72Swap : \u00a7l" + rdmPlaceSwap, "\u00a7aRegularly swap people"));
            this.inv.setItem(33, this.createGuiItem(Material.AIR, "n", new String[0]));
        }
        this.inv.setItem(47, this.createGuiItem(Material.RED_WOOL, "\u00a74Cancel the game", "\u00a7cClose this menu as if nothing ever happened"));
        this.inv.setItem(51, this.createGuiItem(Material.LIME_WOOL, "\u00a72Start the game", "\u00a7aSend the setting of the game to the participants", "\u00a7aand starts a 10 seconds countdown."));
        boolean rdmEffectOnKill = TwistedManhunt.rdmEffectOnKill();
        if (rdmEffectOnKill) {
            this.inv.setItem(39, this.createGlowingGuiItem(Material.POTION, "\u00a72Random effect on kill : \u00a7l" + rdmEffectOnKill, "\u00a7aWhen the hunted kill a hunters, the hunted receive random potion effect"));
            this.inv.setItem(48, this.createGuiItem(Material.POTION, "\u00a72Random effect duration : \u00a7l" + TwistedManhunt.rdmEffectDuration() + "\u00a7a seconds", "\u00a7aDuration of the random effect", " ", "\u00a7a60 = 1 minute", "\u00a7a120 = 2 minutes", "\u00a7a300 = 5 minutes"));
        } else {
            this.inv.setItem(39, this.createGuiItem(Material.POTION, "\u00a72Random effect on kill : \u00a7l" + rdmEffectOnKill, "\u00a7aWhen the hunted kill a hunters, the hunted receive random potion effect"));
            this.inv.setItem(48, this.createGuiItem(Material.AIR, "n", new String[0]));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!e.getInventory().equals(this.inv)) {
            return;
        }
        e.setCancelled(true);
        ItemStack clickedItem = e.getCurrentItem();
        if (clickedItem == null || clickedItem.getType().isAir()) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        switch (e.getRawSlot()) {
            case 1: {
                TwistedManhunt.setShowDistance(!TwistedManhunt.showDistance());
                this.initializeItems();
                break;
            }
            case 2: {
                TwistedManhunt.setTimer();
                this.initializeItems();
                break;
            }
            case 6: {
                TwistedManhunt.setKillDragonisWin(!TwistedManhunt.KillDragonisWin());
                this.initializeItems();
                break;
            }
            case 7: {
                TwistedManhunt.setMaxLives();
                this.initializeItems();
                break;
            }
            case 20: {
                TwistedManhunt.setaddedHearts();
                this.initializeItems();
                break;
            }
            case 29: {
                TwistedManhunt.incrementamountAddedHearts();
                this.initializeItems();
                break;
            }
            case 22: {
                TwistedManhunt.rdmDrop(!TwistedManhunt.rdmDrop());
                this.initializeItems();
                break;
            }
            case 31: {
                TwistedManhunt.consistentRdmDrop(!TwistedManhunt.consistentRdmDrop());
                this.initializeItems();
                break;
            }
            case 24: {
                TwistedManhunt.rdmPlaceSwap(!TwistedManhunt.rdmPlaceSwap());
                this.initializeItems();
                break;
            }
            case 33: {
                TwistedManhunt.placeSwapTime(30);
                this.initializeItems();
                break;
            }
            case 39: {
                TwistedManhunt.rdmEffectOnKill(!TwistedManhunt.rdmEffectOnKill());
                this.initializeItems();
                break;
            }
            case 48: {
                TwistedManhunt.rdmEffectDuration(5);
                this.initializeItems();
                break;
            }
            case 47: {
                p.closeInventory();
                break;
            }
            case 51: {
                p.closeInventory();
                TwistedManhunt.startGame();
            }
        }
    }

    protected ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }

    protected ItemStack createGlowingGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            item.setItemMeta(meta);
        }
        return item;
    }

    public void openInventory(HumanEntity ent) {
        ent.openInventory(this.inv);
    }

    @EventHandler
    public void onInventoryClick(InventoryDragEvent e) {
        if (e.getInventory().equals(this.inv)) {
            e.setCancelled(true);
        }
    }
}

