/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.utils;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.betterarmorstands.GuiItems;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    public static ItemStack itemFromFile(ConfigurationSection section, String itemType) {
        int damage;
        ItemMeta meta;
        Preconditions.checkNotNull((Object)section, (Object)"item cant be null");
        Preconditions.checkArgument((boolean)section.contains("id"), (Object)"item should atleast contain id");
        ItemStack item = new ItemStack((Material)Enums.getIfPresent(Material.class, (String)section.getString("id")).or((Object)Material.DIRT));
        if (section.contains("amount")) {
            item.setAmount(section.getInt("amount", 1));
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        if (section.contains("display")) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)section.getString("display")));
        }
        if (section.contains("lore")) {
            ArrayList lore = new ArrayList();
            section.getStringList("lore").forEach(s -> lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s)));
            meta.setLore(lore);
        }
        if (section.contains("damage") && meta instanceof Damageable && (damage = section.getInt("damage")) > 0) {
            ((Damageable)meta).setDamage(damage);
        }
        if (section.contains("options")) {
            ConfigurationSection options = section.getConfigurationSection("options");
            if (options.getBoolean("enchanted", false)) {
                meta.addEnchant(Enchantment.MENDING, 1, false);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (options.contains("patterns")) {
                if (item.getType() == Material.SHIELD) {
                    BlockStateMeta blockStateMeta = (BlockStateMeta)meta;
                    BlockState state = blockStateMeta.getBlockState();
                    Banner bannerState = (Banner)state;
                    bannerState.setPatterns(ItemBuilder.getBannerPatterns(options.getConfigurationSection("patterns")));
                    bannerState.update();
                    blockStateMeta.setBlockState((BlockState)bannerState);
                } else if (meta instanceof BannerMeta) {
                    BannerMeta banner = (BannerMeta)meta;
                    banner.setPatterns(ItemBuilder.getBannerPatterns(options.getConfigurationSection("patterns")));
                }
            } else if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta leather = (LeatherArmorMeta)meta;
                String colorStr = options.getString("color");
                if (colorStr != null) {
                    leather.setColor(ItemBuilder.parseColor(colorStr));
                }
            } else if (meta instanceof PotionMeta && options.contains("color")) {
                PotionMeta potion = (PotionMeta)meta;
                potion.setColor(Color.fromRGB((int)options.getInt("color", 0)));
            } else if (meta instanceof SkullMeta && options.contains("texture")) {
                SkullMeta skullMeta = (SkullMeta)meta;
                Tweakin.getPlugin().getNmsHelper().applyHeadTexture(skullMeta, options.getString("texture"));
            }
            if (options.contains("model")) {
                meta.setCustomModelData(Integer.valueOf(options.getInt("model", 0)));
            }
        }
        if (section.contains("enchants")) {
            for (String string : section.getStringList("enchants")) {
                String[] l = string.split(" ");
                if (l.length != 2) continue;
                String name = ((String)l[0]).toLowerCase();
                int level = Integer.parseInt((String)l[1]);
                Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name));
                if (enchant == null) continue;
                meta.addEnchant(enchant, level, true);
            }
        }
        if (section.contains("flags")) {
            List itemFlags = section.getStringList("flags").stream().map(m -> m.toUpperCase()).collect(Collectors.toList());
            for (String str : itemFlags) {
                if (str.equals("ALL")) {
                    meta.addItemFlags(ItemFlag.values());
                    break;
                }
                ItemFlag itemFlag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)str).orNull();
                if (itemFlag == null) continue;
                meta.addItemFlags(new ItemFlag[]{itemFlag});
            }
        }
        if (meta instanceof FireworkEffectMeta && section.contains("firework")) {
            FireworkEffectMeta firework = (FireworkEffectMeta)meta;
            ConfigurationSection fireworkConfig = section.getConfigurationSection("firework");
            if (fireworkConfig != null) {
                FireworkEffect.Builder builder = FireworkEffect.builder();
                builder.with(FireworkEffect.Type.STAR);
                List strColors = fireworkConfig.getStringList("colors");
                ArrayList<Color> colors = new ArrayList<Color>(strColors.size());
                for (String str : strColors) {
                    colors.add(ItemBuilder.parseColor(str));
                }
                builder.withColor(colors);
                firework.setEffect(builder.build());
            }
        }
        item.setItemMeta(meta);
        if (itemType != null) {
            NBTItem nbtItem = new NBTItem(item);
            nbtItem.setString(itemType, " ");
            item = nbtItem.getItem();
        }
        return item;
    }

    private static Color parseColor(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return Color.BLACK;
        }
        String[] rgb = StringUtils.split((String)StringUtils.deleteWhitespace((String)str), (char)',');
        if (rgb.length < 3) {
            return ItemBuilder.getColorFromString(str);
        }
        return Color.fromRGB((int)NumberUtils.toInt((String)rgb[0], (int)0), (int)NumberUtils.toInt((String)rgb[1], (int)0), (int)NumberUtils.toInt((String)rgb[2], (int)0));
    }

    private static Color getColorFromString(String str) {
        switch (str) {
            case "WHITE": {
                return Color.WHITE;
            }
            case "RED": {
                return Color.RED;
            }
            case "BLUE": {
                return Color.BLUE;
            }
            case "GREEN": {
                return Color.GREEN;
            }
            case "AQUA": {
                return Color.AQUA;
            }
            case "BLACK": {
                return Color.BLACK;
            }
            case "SILVER": {
                return Color.SILVER;
            }
            case "MAROON": {
                return Color.MAROON;
            }
            case "YELLOW": {
                return Color.YELLOW;
            }
            case "OLIVE": {
                return Color.OLIVE;
            }
            case "ORANGE": {
                return Color.ORANGE;
            }
            case "PURPLE": {
                return Color.PURPLE;
            }
            case "TEAL": {
                return Color.TEAL;
            }
        }
        return Color.WHITE;
    }

    private static List<Pattern> getBannerPatterns(ConfigurationSection patterns) {
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        if (patterns != null) {
            for (String pattern : patterns.getKeys(false)) {
                PatternType type = PatternType.getByIdentifier((String)pattern);
                if (type == null) {
                    type = (PatternType)Enums.getIfPresent(PatternType.class, (String)pattern.toUpperCase(Locale.ENGLISH)).or((Object)PatternType.BASE);
                }
                DyeColor color = (DyeColor)Enums.getIfPresent(DyeColor.class, (String)patterns.getString(pattern).toUpperCase(Locale.ENGLISH)).or((Object)DyeColor.WHITE);
                list.add(new Pattern(color, type));
            }
        }
        return list;
    }

    public static ItemStack guiItemFromFile(ConfigurationSection section, String itemType) {
        ItemStack item = ItemBuilder.itemFromFile(section, null);
        NBTItem nbti = new NBTItem(item);
        nbti.setString("misc-item", itemType);
        return nbti.getItem();
    }

    public static ItemStack asGuiItem(ConfigurationSection section, GuiItems guiItem) {
        ItemStack item = ItemBuilder.itemFromFile(section, null);
        NBTItem nbti = new NBTItem(item);
        nbti.setString("tweakin-armor-stand-gui", guiItem.toString());
        return nbti.getItem();
    }

    public static boolean hasKey(ItemStack item, String key) {
        NBTItem nbti = new NBTItem(item);
        if (nbti.hasKey("misc-item")) {
            return nbti.getString("misc-item").equals(key);
        }
        return false;
    }

    public static ItemStack damageItem(int amount, ItemStack item, Random random, Player player) {
        ItemMeta meta = item.getItemMeta();
        if (!(meta instanceof Damageable) || amount < 0) {
            return item;
        }
        int m = item.getEnchantmentLevel(Enchantment.DURABILITY);
        int k = 0;
        int l = 0;
        while (m > 0 && l < amount) {
            if (random.nextInt(m + 1) > 0) {
                ++k;
            }
            ++l;
        }
        amount -= k;
        if (player != null) {
            PlayerItemDamageEvent damageEvent = new PlayerItemDamageEvent(player, item, amount);
            Tweakin.getPlugin().getServer().getPluginManager().callEvent((Event)damageEvent);
            if (amount != damageEvent.getDamage() || damageEvent.isCancelled()) {
                damageEvent.getPlayer().updateInventory();
            } else if (damageEvent.isCancelled()) {
                return item;
            }
            amount = damageEvent.getDamage();
        }
        if (amount <= 0) {
            return item;
        }
        Damageable damageable = (Damageable)meta;
        damageable.setDamage(damageable.getDamage() + amount);
        item.setItemMeta(meta);
        return item;
    }
}

