/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.utils;

import com.github.sachin.tweakin.Tweakin;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class CustomBlockData
implements PersistentDataContainer {
    private Location location;
    private Chunk chunk;
    private NamespacedKey key;
    private PersistentDataContainer pdc;

    public CustomBlockData(Location location) {
        this.location = location;
        this.chunk = location.getBlock().getChunk();
        int x = location.getBlockX() & 0xF;
        int y = location.getBlockY();
        int z = location.getBlockZ() & 0xF;
        this.key = Tweakin.getKey(String.format("x%dy%dz%d", x, y, z));
        this.pdc = this.getPersistentDataContainer();
    }

    private PersistentDataContainer getPersistentDataContainer() {
        PersistentDataContainer chunkPDC = this.chunk.getPersistentDataContainer();
        if (chunkPDC.has(this.key, PersistentDataType.TAG_CONTAINER)) {
            PersistentDataContainer blockPDC = (PersistentDataContainer)chunkPDC.get(this.key, PersistentDataType.TAG_CONTAINER);
            assert (blockPDC != null);
            return blockPDC;
        }
        PersistentDataContainer blockPDC = chunkPDC.getAdapterContext().newPersistentDataContainer();
        chunkPDC.set(this.key, PersistentDataType.TAG_CONTAINER, (Object)blockPDC);
        return blockPDC;
    }

    private void save() {
        Chunk chunk = this.location.getBlock().getChunk();
        chunk.getPersistentDataContainer().set(this.key, PersistentDataType.TAG_CONTAINER, (Object)this.pdc);
    }

    public <T, Z> void set(@Nonnull NamespacedKey namespacedKey, @Nonnull PersistentDataType<T, Z> persistentDataType, @Nonnull Z z) {
        this.pdc.set(namespacedKey, persistentDataType, z);
        this.save();
    }

    public <T, Z> boolean has(@Nonnull NamespacedKey namespacedKey, @Nonnull PersistentDataType<T, Z> persistentDataType) {
        return this.pdc.has(namespacedKey, persistentDataType);
    }

    public <T, Z> Z get(@Nonnull NamespacedKey namespacedKey, @Nonnull PersistentDataType<T, Z> persistentDataType) {
        return (Z)this.pdc.get(namespacedKey, persistentDataType);
    }

    public <T, Z> Z getOrDefault(@Nonnull NamespacedKey namespacedKey, @Nonnull PersistentDataType<T, Z> persistentDataType, @Nonnull Z z) {
        return (Z)this.pdc.getOrDefault(namespacedKey, persistentDataType, z);
    }

    public Set<NamespacedKey> getKeys() {
        return this.pdc.getKeys();
    }

    public void remove(@Nonnull NamespacedKey namespacedKey) {
        this.pdc.remove(namespacedKey);
        this.save();
    }

    public boolean isEmpty() {
        return this.pdc.isEmpty();
    }

    public PersistentDataAdapterContext getAdapterContext() {
        return this.pdc.getAdapterContext();
    }

    public Location getLocation() {
        return this.location;
    }
}

