/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.villagerdeathmessage;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

@Tweak(name="villager-death-message")
public class VillagerDeathMessageTweak
extends BaseTweak
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onVillagerDeath(EntityDeathEvent e) {
        if (e.getEntity() instanceof Villager && !this.getBlackListWorlds().contains(e.getEntity().getWorld().getName())) {
            String world;
            Location loc = e.getEntity().getLocation();
            switch (e.getEntity().getWorld().getEnvironment()) {
                case NETHER: {
                    world = "\u00a7cThe Nether";
                    break;
                }
                case THE_END: {
                    world = "\u00a7dThe End";
                }
                default: {
                    world = "\u00a7aOverworld";
                }
            }
            String message = this.getTweakManager().getMessageManager().getMessageWithoutPrefix("villager-death-message").replace("%x%", String.valueOf(loc.getBlockX())).replace("%y%", String.valueOf(loc.getBlockY())).replace("%z%", String.valueOf(loc.getBlockZ())).replace("%world-type%", world);
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.hasPermission(player, Permissions.VIL_DTH_MSG)) continue;
                player.sendMessage(message);
            }
        }
    }
}

