/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.snowballknockback;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.modules.snowballknockback.SBKFlag;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="snowball-knockback")
public class SnowBallKnockBackTweak
extends BaseTweak
implements Listener {
    private SBKFlag flag;

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.plugin.isWorldGuardEnabled) {
            this.flag = (SBKFlag)this.plugin.getWGFlagManager().getFlag("tweakin-snowball-knockback");
        }
    }

    @EventHandler
    public void onShoot(final ProjectileHitEvent e) {
        Entity hitEntity;
        if ((e.getEntityType() == EntityType.SNOWBALL || e.getEntityType() == EntityType.EGG) && (hitEntity = e.getHitEntity()) != null) {
            if (this.getBlackListWorlds().contains(hitEntity.getWorld().getName())) {
                return;
            }
            if (this.flag != null && !this.flag.queryFlag(hitEntity.getLocation())) {
                return;
            }
            if (hitEntity instanceof Player) {
                UUID uuid = hitEntity.getUniqueId();
                boolean isActualPlayer = false;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getUniqueId().equals(uuid)) continue;
                    isActualPlayer = true;
                    break;
                }
                if (!isActualPlayer) {
                    return;
                }
            }
            hitEntity.setVelocity(e.getEntity().getVelocity().multiply(this.getConfig().getDouble("modifier")));
            if (hitEntity instanceof LivingEntity) {
                new BukkitRunnable(){

                    public void run() {
                        if (e.getEntity().getShooter() instanceof Player) {
                            ((LivingEntity)hitEntity).damage(SnowBallKnockBackTweak.this.getConfig().getDouble("damage"), (Entity)((Player)e.getEntity().getShooter()));
                        } else {
                            ((LivingEntity)hitEntity).damage(SnowBallKnockBackTweak.this.getConfig().getDouble("damage"));
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 2L);
            }
        }
    }
}

