/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.shulkerboxpreview;

import com.github.sachin.tweakin.Tweakin;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ShulkerGui
implements InventoryHolder {
    private UUID uuid;
    private ShulkerBox shulker;
    private final Inventory inventory;
    private int slot;
    private ItemStack shulkerItem;

    public ShulkerGui(Player player, ShulkerBox shulker, int slot, ItemStack shulkerItem, String title) {
        this.uuid = player.getUniqueId();
        this.shulker = shulker;
        this.slot = slot;
        this.shulkerItem = shulkerItem;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)title);
    }

    public void update(boolean close) {
        BlockStateMeta im = (BlockStateMeta)this.shulkerItem.getItemMeta();
        ShulkerBox shulker = (ShulkerBox)im.getBlockState();
        shulker.getInventory().setContents(this.getInventory().getContents());
        im.setBlockState((BlockState)shulker);
        shulker.update();
        this.shulkerItem.setItemMeta((ItemMeta)im);
        this.getPlayer().getInventory().setItem(this.slot, this.shulkerItem);
    }

    public void removeDuplicateShulkers() {
        int i = 9;
        while (i < 44) {
            ItemStack item;
            if (i != this.slot && (item = this.getPlayer().getInventory().getItem(i)) != null && item.getType() != Material.AIR && item.isSimilar(this.shulkerItem)) {
                this.getPlayer().getInventory().setItem(i, null);
                break;
            }
            ++i;
        }
    }

    public ShulkerBox getShulker() {
        return this.shulker;
    }

    public void open() {
        this.inventory.setContents(this.shulker.getInventory().getContents());
        new BukkitRunnable(){

            public void run() {
                ShulkerGui.this.getPlayer().openInventory(ShulkerGui.this.inventory);
            }
        }.runTaskLater((Plugin)Tweakin.getPlugin(), 1L);
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getShulkerItem() {
        return this.shulkerItem;
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

