/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.shearitemframe;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.shearitemframe.SIFFlag;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="shear-item-frame")
public class ShearItemFrameTweak
extends BaseTweak
implements Listener {
    private final NamespacedKey key = Tweakin.getKey("tweakin-frame");
    private SIFFlag flag;

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.plugin.isWorldGuardEnabled) {
            this.flag = (SIFFlag)this.plugin.getWGFlagManager().getFlag("tweakin-shear-item-frame");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onShear(PlayerInteractEntityEvent e) {
        if (!(e.getRightClicked() instanceof ItemFrame)) {
            return;
        }
        Player player = e.getPlayer();
        if (this.plugin.griefCompat != null && !this.plugin.griefCompat.canBuild(player, e.getRightClicked().getLocation(), Material.SHEARS)) {
            return;
        }
        if (player.isSneaking() || !this.hasPermission(player, Permissions.SHEARITEMFRAME)) {
            return;
        }
        if (this.getBlackListWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (this.flag != null && !this.flag.queryFlag(player, e.getRightClicked().getLocation())) {
            return;
        }
        ItemStack item = e.getPlayer().getInventory().getItemInMainHand().clone();
        if (item.getType() != Material.SHEARS) {
            return;
        }
        ItemFrame frame = (ItemFrame)e.getRightClicked();
        if (frame.getPersistentDataContainer().has(this.key, PersistentDataType.INTEGER)) {
            return;
        }
        if (!frame.getItem().getType().isAir()) {
            frame.setVisible(false);
            player.getWorld().playSound(frame.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
            frame.getPersistentDataContainer().set(this.key, PersistentDataType.INTEGER, (Object)1);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDamage(EntityDamageByEntityEvent e) {
        if (e.getEntity() instanceof ItemFrame) {
            final ItemFrame frame = (ItemFrame)e.getEntity();
            new BukkitRunnable(){

                public void run() {
                    if (frame.getItem().getType().isAir() && frame.getPersistentDataContainer().has(ShearItemFrameTweak.this.key, PersistentDataType.INTEGER)) {
                        frame.setVisible(true);
                        frame.getPersistentDataContainer().remove(ShearItemFrameTweak.this.key);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 2L);
        }
    }
}

