/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.patdogs;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.modules.patdogs.PatTime;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

@Tweak(name="pat-dogs")
public class PatDogTweak
extends BaseTweak
implements Listener {
    @EventHandler
    public void onPat(PlayerInteractEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = e.getPlayer();
        if (player.getInventory().getItemInMainHand().getType() != Material.AIR || !player.isSneaking()) {
            return;
        }
        if (e.getRightClicked() instanceof Wolf && this.hasPermission(player, Permissions.PAT_DOG)) {
            double health;
            Wolf wolf = (Wolf)e.getRightClicked();
            PatTime time = new PatTime((Tameable)wolf);
            if (!time.canPet(this.getConfig().getLong("cooldown", 20L)) || !wolf.isSitting()) {
                return;
            }
            Location loc = wolf.getLocation();
            player.getWorld().spawnParticle(Particle.HEART, loc.add(0.0, 0.5, 0.0), 1, 0.0, 0.0, 0.0, 0.1);
            player.getWorld().playSound(wolf.getLocation(), Sound.ENTITY_WOLF_WHINE, 1.0f, 0.5f + (float)Math.random() * 0.5f);
            player.swingMainHand();
            time.setPetTime();
            if (this.getConfig().getBoolean("heal") && wolf.getHealth() < wolf.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && (health = wolf.getHealth() + Math.random()) < 20.0) {
                wolf.setHealth(health);
            }
            e.setCancelled(true);
        } else if (e.getRightClicked() instanceof Cat && this.hasPermission(player, Permissions.PAT_CAT) && this.getConfig().getBoolean("pat-cats", false)) {
            double health;
            Cat cat = (Cat)e.getRightClicked();
            PatTime time = new PatTime((Tameable)cat);
            if (!time.canPet(this.getConfig().getLong("cooldown", 20L)) || !cat.isSitting()) {
                return;
            }
            Location loc = cat.getLocation();
            player.getWorld().spawnParticle(Particle.HEART, loc.add(0.0, 0.5, 0.0), 1, 0.0, 0.0, 0.0, 0.1);
            player.getWorld().playSound(cat.getLocation(), Sound.ENTITY_CAT_PURREOW, 1.0f, 0.5f + (float)Math.random() * 0.5f);
            player.swingMainHand();
            time.setPetTime();
            if (this.getConfig().getBoolean("heal") && cat.getHealth() < cat.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && (health = cat.getHealth() + Math.random()) < 20.0) {
                cat.setHealth(health);
            }
            e.setCancelled(true);
        }
    }
}

