/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.noteblock;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.NotePlayEvent;

@Tweak(name="noteblock-mob-sounds")
public class NoteBlockHeadsTweak
extends BaseTweak
implements Listener {
    private final List<BlockFace> VALID_FACES = Arrays.asList(BlockFace.DOWN, BlockFace.UP, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH);
    private Map<String, Sound> allowedHeads;

    @EventHandler
    public void noteBlockPlay(NotePlayEvent e) {
        Block block = e.getBlock();
        if (this.getBlackListWorlds().contains(block.getWorld().getName())) {
            return;
        }
        Sound sound = null;
        for (BlockFace b : this.VALID_FACES) {
            Block blockSide = block.getRelative(b);
            sound = this.getSound(blockSide.getType());
            if (sound != null) break;
        }
        if (sound != null) {
            e.setCancelled(true);
            float pitch = (float)Math.pow(2.0, (double)(e.getNote().getId() - 12) / 12.0);
            block.getWorld().playSound(block.getLocation(), sound, SoundCategory.BLOCKS, 1.0f, pitch);
        }
    }

    @Override
    public void reload() {
        super.reload();
        this.createAllowedHeads();
        List blackListHeads = this.getConfig().getStringList("black-list-heads");
        if (blackListHeads == null) {
            return;
        }
        for (String h : blackListHeads) {
            if (!this.allowedHeads.containsKey(h)) continue;
            this.allowedHeads.remove(h);
        }
    }

    private void createAllowedHeads() {
        this.allowedHeads = new HashMap<String, Sound>();
        this.allowedHeads.put("CREEPER_WALL_HEAD", Sound.ENTITY_CREEPER_PRIMED);
        this.allowedHeads.put("SKELETON_WALL_SKULL", Sound.ENTITY_SKELETON_AMBIENT);
        this.allowedHeads.put("ZOMBIE_WALL_HEAD", Sound.ENTITY_ZOMBIE_AMBIENT);
        this.allowedHeads.put("DRAGON_WALL_HEAD", Sound.ENTITY_ENDER_DRAGON_AMBIENT);
        this.allowedHeads.put("WITHER_SKELETON_WALL_SKULL", Sound.ENTITY_WITHER_SKELETON_AMBIENT);
    }

    private Sound getSound(Material type) {
        for (String h : this.allowedHeads.keySet()) {
            if (type.name() != h) continue;
            return this.allowedHeads.get(h);
        }
        return null;
    }
}

