/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.netherportalcoords;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Tweak(name="nether-portal-coords")
public class NetherPortalCoordsTweak
extends BaseTweak
implements Listener {
    private Map<String, String> worldPairs;

    public Map<String, String> getWorldPairs() {
        return this.worldPairs;
    }

    @Override
    public void reload() {
        super.reload();
        this.worldPairs = new HashMap<String, String>();
        if (this.getConfig().isList("world-pairs")) {
            for (String pair : this.getConfig().getStringList("world-pairs")) {
                String[] pairs = pair.split("\\|");
                this.worldPairs.put(pairs[0], pairs[1]);
            }
        } else {
            this.plugin.getLogger().severe("Update your world-pairs to a list instead of a config section in nether-portal-coords tweak");
        }
    }

    @EventHandler
    public void portalClickEvent(PlayerInteractEvent e) {
        if (e.getItem() == null) {
            return;
        }
        if (e.getItem().getType() != Material.COMPASS) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = e.getItem().clone();
        ItemMeta meta = item.getItemMeta();
        Player player = e.getPlayer();
        if (!this.hasPermission(player, Permissions.NETHERCOORDS)) {
            return;
        }
        if (this.isUntrackedCompass(item) && e.getAction() == Action.RIGHT_CLICK_AIR) {
            if (player.isSneaking()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.COMPASS));
                return;
            }
            Location loc = this.getTracingLocation(item);
            if (loc != null && loc.getWorld().getName().equals(player.getWorld().getName())) {
                meta.setDisplayName("Tracking");
                CompassMeta cMeta = (CompassMeta)meta;
                cMeta.setLodestoneTracked(false);
                cMeta.setLodestone(loc);
                item.setItemMeta(meta);
                player.getInventory().setItemInMainHand(item);
                return;
            }
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        if (clickedBlock.getType() != Material.NETHER_PORTAL) {
            return;
        }
        String worldName = player.getWorld().getName();
        for (String overworld : this.worldPairs.keySet()) {
            ArrayList<String> lore;
            Location newTrackLocation;
            World world;
            if (worldName.equals(overworld)) {
                world = Bukkit.getWorld((String)this.worldPairs.get(overworld));
                if (world == null) continue;
                newTrackLocation = new Location(world, (double)(clickedBlock.getLocation().getBlockX() / 8), (double)clickedBlock.getLocation().getBlockY(), (double)(clickedBlock.getLocation().getBlockZ() / 8));
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aNether Portal Syncing Compass"));
                lore = new ArrayList<String>();
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6Nether: &e" + newTrackLocation.getBlockX() + "," + newTrackLocation.getBlockY() + "," + newTrackLocation.getBlockZ())));
                lore.add(ChatColor.GRAY + "Follow the above coordinates in");
                lore.add(ChatColor.GRAY + "nether to link the portals");
                lore.add(ChatColor.YELLOW + "RIGHT-CLICK in air to track");
                lore.add(ChatColor.YELLOW + "SHIFT+RIGHT-CLICK to clear");
                meta.setLore(lore);
                item.setItemMeta(meta);
                item = this.setTracingLocation(newTrackLocation, item);
                player.getInventory().setItemInMainHand(item);
                continue;
            }
            if (!worldName.equals(this.worldPairs.get(overworld)) || (world = Bukkit.getWorld((String)overworld)) == null) continue;
            newTrackLocation = new Location(world, (double)(clickedBlock.getLocation().getBlockX() * 8), (double)clickedBlock.getLocation().getBlockY(), (double)(clickedBlock.getLocation().getBlockZ() * 8));
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aNether Portal Syncing Compass"));
            lore = new ArrayList();
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6OverWorld: &e" + newTrackLocation.getBlockX() + "," + newTrackLocation.getBlockY() + "," + newTrackLocation.getBlockZ())));
            lore.add(ChatColor.GRAY + "Follow the above coordinates in");
            lore.add(ChatColor.GRAY + "overworld to link the portals");
            lore.add(ChatColor.YELLOW + "RIGHT-CLICK in air to track");
            lore.add(ChatColor.YELLOW + "SHIFT+RIGHT-CLICK to clear");
            meta.setLore(lore);
            item.setItemMeta(meta);
            item = this.setTracingLocation(newTrackLocation, item);
            player.getInventory().setItemInMainHand(item);
        }
    }

    private boolean isUntrackedCompass(ItemStack item) {
        NBTItem nbti = new NBTItem(item);
        if (nbti.hasKey("npct")) {
            return !nbti.getBoolean("npct");
        }
        return false;
    }

    private ItemStack setTracingLocation(Location loc, ItemStack item) {
        NBTItem nbti = new NBTItem(item);
        nbti.setBoolean("npct", false);
        nbti.setInt("npcx", loc.getBlockX());
        nbti.setInt("npcy", loc.getBlockY());
        nbti.setInt("npcz", loc.getBlockZ());
        nbti.setString("npcw", loc.getWorld().getName());
        return nbti.getItem();
    }

    private Location getTracingLocation(ItemStack item) {
        NBTItem nbti = new NBTItem(item);
        if (nbti.hasKey("npct") && !nbti.getBoolean("npct")) {
            int x = nbti.getInt("npcx");
            int y = nbti.getInt("npcy");
            int z = nbti.getInt("npcz");
            String worldName = nbti.getString("npcw");
            if (Bukkit.getWorld((String)worldName) != null) {
                nbti.setBoolean("npct", true);
                item = nbti.getItem();
                return new Location(Bukkit.getWorld((String)worldName), (double)x, (double)y, (double)z);
            }
        }
        return null;
    }
}

