/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.morerecipes.recipes;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.morerecipes.BaseRecipe;
import com.github.sachin.tweakin.modules.morerecipes.MoreRecipesTweak;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class CraftableCoralBlocks {
    public static final ItemStack TUBE = new ItemStack(Material.TUBE_CORAL_BLOCK);
    public static final ItemStack BRAIN = new ItemStack(Material.BRAIN_CORAL_BLOCK);
    public static final ItemStack BUBBLE = new ItemStack(Material.BUBBLE_CORAL_BLOCK);
    public static final ItemStack FIRE = new ItemStack(Material.FIRE_CORAL_BLOCK);
    public static final ItemStack HORN = new ItemStack(Material.HORN_CORAL_BLOCK);

    public static class ThreeByThree
    extends BaseRecipe {
        public ThreeByThree(MoreRecipesTweak instance) {
            super("craftable-coral-blocks-three-by-three", instance);
        }

        @Override
        public void register() {
            this.add3by3Recipe(Material.TUBE_CORAL, Material.TUBE_CORAL_FAN, TUBE);
            this.add3by3Recipe(Material.BRAIN_CORAL, Material.BRAIN_CORAL_FAN, BRAIN);
            this.add3by3Recipe(Material.BUBBLE_CORAL, Material.BUBBLE_CORAL_FAN, BUBBLE);
            this.add3by3Recipe(Material.FIRE_CORAL, Material.FIRE_CORAL_FAN, FIRE);
            this.add3by3Recipe(Material.HORN_CORAL, Material.HORN_CORAL_FAN, HORN);
        }

        private void add3by3Recipe(Material coral, Material fan, ItemStack block) {
            NamespacedKey key = Tweakin.getKey(String.valueOf(this.name) + "-" + block.getType().toString().toLowerCase());
            ShapedRecipe recipe = new ShapedRecipe(key, block).shape(new String[]{"AAA", "AAA", "AAA"}).setIngredient('A', (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{coral, fan}));
            this.addRecipe(key, (Recipe)recipe);
        }
    }

    public static class TwoByTwo
    extends BaseRecipe {
        public TwoByTwo(MoreRecipesTweak instance) {
            super("craftable-coral-blocks-two-by-two", instance);
        }

        @Override
        public void register() {
            this.add2by2Recipe(Material.TUBE_CORAL, Material.TUBE_CORAL_FAN, TUBE);
            this.add2by2Recipe(Material.BRAIN_CORAL, Material.BRAIN_CORAL_FAN, BRAIN);
            this.add2by2Recipe(Material.BUBBLE_CORAL, Material.BUBBLE_CORAL_FAN, BUBBLE);
            this.add2by2Recipe(Material.FIRE_CORAL, Material.FIRE_CORAL_FAN, FIRE);
            this.add2by2Recipe(Material.HORN_CORAL, Material.HORN_CORAL_FAN, HORN);
        }

        private void add2by2Recipe(Material coral, Material fan, ItemStack block) {
            NamespacedKey key = Tweakin.getKey(String.valueOf(this.name) + "-" + block.getType().toString().toLowerCase());
            ShapedRecipe recipe = new ShapedRecipe(key, block).shape(new String[]{"AA", "AA"}).setIngredient('A', (RecipeChoice)new RecipeChoice.MaterialChoice(new Material[]{coral, fan}));
            this.addRecipe(key, (Recipe)recipe);
        }
    }
}

