/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.morerecipes;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.bstats.Metrics;
import com.github.sachin.tweakin.modules.morerecipes.BaseRecipe;
import com.github.sachin.tweakin.modules.morerecipes.recipes.BackToBlocksSlabs;
import com.github.sachin.tweakin.modules.morerecipes.recipes.BackToBlocksStairs;
import com.github.sachin.tweakin.modules.morerecipes.recipes.BlackDyeRecipe;
import com.github.sachin.tweakin.modules.morerecipes.recipes.CompactRecipes;
import com.github.sachin.tweakin.modules.morerecipes.recipes.CompatShulkerRecipe;
import com.github.sachin.tweakin.modules.morerecipes.recipes.CraftableCoralBlocks;
import com.github.sachin.tweakin.modules.morerecipes.recipes.CraftableHorseArmor;
import com.github.sachin.tweakin.modules.morerecipes.recipes.EasyDispenser;
import com.github.sachin.tweakin.modules.morerecipes.recipes.EasyMinecarts;
import com.github.sachin.tweakin.modules.morerecipes.recipes.EasyRepeaters;
import com.github.sachin.tweakin.modules.morerecipes.recipes.EasyStoneTools;
import com.github.sachin.tweakin.modules.morerecipes.recipes.MoreBlocks;
import com.github.sachin.tweakin.modules.morerecipes.recipes.MoreStoneCutterRecipes;
import com.github.sachin.tweakin.modules.morerecipes.recipes.PowderToGlass;
import com.github.sachin.tweakin.modules.morerecipes.recipes.RottenFleshToLeather;
import com.github.sachin.tweakin.modules.morerecipes.recipes.universaldyeing.UniversalDyeing;
import com.github.sachin.tweakin.utils.ConfigUpdater;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import com.google.common.base.Enums;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

@Tweak(name="more-recipes")
public class MoreRecipesTweak
extends BaseTweak {
    private FileConfiguration recipeFile;
    private FileConfiguration customRecipeFile;
    private final List<NamespacedKey> simpleRecipes = new ArrayList<NamespacedKey>();
    private List<BaseRecipe> baseRecipes;

    public List<BaseRecipe> getBaseRecipes() {
        if (this.baseRecipes == null) {
            this.baseRecipes = new ArrayList<BaseRecipe>();
        }
        if (this.baseRecipes.isEmpty()) {
            this.baseRecipes.add(new BackToBlocksSlabs(this));
            this.baseRecipes.add(new BackToBlocksStairs(this));
            this.baseRecipes.add(new EasyDispenser(this));
            this.baseRecipes.add(new EasyRepeaters(this));
            this.baseRecipes.add(new EasyMinecarts(this));
            this.baseRecipes.add(new CompactRecipes(this));
            this.baseRecipes.add(new CompatShulkerRecipe(this));
            this.baseRecipes.add(new EasyStoneTools(this));
            this.baseRecipes.add(new MoreStoneCutterRecipes(this));
            this.baseRecipes.add(new RottenFleshToLeather(this));
            this.baseRecipes.add(new UniversalDyeing(this));
            this.baseRecipes.add(new BlackDyeRecipe.Charcoal(this));
            this.baseRecipes.add(new BlackDyeRecipe.Coal(this));
            this.baseRecipes.add(new PowderToGlass(this));
            this.baseRecipes.add(new MoreBlocks(this));
            this.baseRecipes.add(new CraftableHorseArmor(this));
            this.baseRecipes.add(new CraftableCoralBlocks.TwoByTwo(this));
            this.baseRecipes.add(new CraftableCoralBlocks.ThreeByThree(this));
        }
        return this.baseRecipes;
    }

    @Override
    public void register() {
        super.register();
        this.saveRecipeFile();
        int registerdRecipes = 0;
        int enabledModules = 0;
        registerdRecipes += this.registerSimpleRecipes();
        for (BaseRecipe baseRecipe : this.getBaseRecipes()) {
            if (baseRecipe instanceof UniversalDyeing) {
                baseRecipe.unregister();
                baseRecipe.register();
                ++enabledModules;
            } else if (this.recipeFile.getBoolean(baseRecipe.name, true)) {
                baseRecipe.register();
                ++enabledModules;
            } else {
                baseRecipe.unregister();
            }
            registerdRecipes = baseRecipe.getRecipes().size() + registerdRecipes;
        }
        this.plugin.getLogger().info("Registered " + registerdRecipes + " recipes");
        if (enabledModules == this.baseRecipes.size()) {
            this.plugin.getLogger().info("Recipes go brrrrr..");
        }
    }

    @Override
    public void unregister() {
        super.unregister();
        for (NamespacedKey key : this.simpleRecipes) {
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        for (BaseRecipe baseRecipe : this.getBaseRecipes()) {
            if (baseRecipe.getRecipes().isEmpty()) continue;
            baseRecipe.unregister();
        }
    }

    public void saveRecipeFile() {
        File recipeFile = new File(this.plugin.getDataFolder(), "more-recipes.yml");
        File customRecipeFile = new File(this.plugin.getDataFolder(), "custom-recipes.yml");
        if (!recipeFile.exists()) {
            this.plugin.saveResource("more-recipes.yml", false);
        }
        if (!customRecipeFile.exists()) {
            this.plugin.saveResource("custom-recipes.yml", false);
        }
        try {
            ConfigUpdater.update(this.plugin, "more-recipes.yml", recipeFile, new ArrayList<String>(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.recipeFile = YamlConfiguration.loadConfiguration((File)recipeFile);
        this.customRecipeFile = YamlConfiguration.loadConfiguration((File)customRecipeFile);
    }

    public int registerSimpleRecipes() {
        int registeredRecipes = 0;
        this.customRecipeFile = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "custom-recipes.yml"));
        for (String key : this.customRecipeFile.getKeys(false)) {
            if (!this.customRecipeFile.isConfigurationSection(key)) continue;
            ConfigurationSection recipe = this.customRecipeFile.getConfigurationSection(key);
            ItemStack result = new ItemStack((Material)Enums.getIfPresent(Material.class, (String)recipe.getString("result", "AIR").toUpperCase()).get());
            if (!recipe.getBoolean("enabled", true) || result.getType() == Material.AIR) continue;
            result.setAmount(recipe.getInt("amount", 1));
            String type = recipe.getString("type", "none");
            NamespacedKey recipeKey = Tweakin.getKey("simple-recipes-" + recipe.getName() + "-" + type);
            if (type.equalsIgnoreCase("shaped") && recipe.contains("pattern") && recipe.contains("keys")) {
                ShapedRecipe shapedRecipe = new ShapedRecipe(recipeKey, result);
                List patternList = recipe.getStringList("pattern");
                boolean invalidPattern = false;
                if (patternList.size() > 3) {
                    invalidPattern = true;
                }
                for (String s : patternList) {
                    if (s.length() <= 3) continue;
                    invalidPattern = true;
                }
                if (invalidPattern) continue;
                shapedRecipe.shape(patternList.toArray(new String[0]));
                for (String ing : recipe.getConfigurationSection("keys").getKeys(false)) {
                    RecipeChoice choice = TweakItem.getIngredient(recipe.getString("keys." + ing), recipe.getBoolean("exact", false));
                    if (choice == null) continue;
                    shapedRecipe.setIngredient(ing.charAt(0), choice);
                }
                this.addRecipe(recipeKey, (Recipe)shapedRecipe);
                ++registeredRecipes;
                continue;
            }
            if (!type.equalsIgnoreCase("shapeless")) continue;
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(recipeKey, result);
            for (String ing : recipe.getStringList("ingredients")) {
                RecipeChoice choice = TweakItem.getIngredient(ing, recipe.getBoolean("exact", false));
                if (choice == null) continue;
                shapelessRecipe.addIngredient(choice);
            }
            this.addRecipe(recipeKey, (Recipe)shapelessRecipe);
            ++registeredRecipes;
        }
        return registeredRecipes;
    }

    private void addRecipe(NamespacedKey key, Recipe recipe) {
        if (Bukkit.getRecipe((NamespacedKey)key) == null) {
            Bukkit.addRecipe((Recipe)recipe);
            this.simpleRecipes.add(key);
        }
    }

    public FileConfiguration getRecipeFile() {
        return this.recipeFile;
    }

    public void addBstatsGraph(Metrics metrics) {
        metrics.addCustomChart(new Metrics.AdvancedPie("Enabled-Recipes", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (BaseRecipe recipe : MoreRecipesTweak.this.baseRecipes) {
                    if (recipe instanceof UniversalDyeing || !MoreRecipesTweak.this.recipeFile.getBoolean(recipe.name, true)) continue;
                    map.put(recipe.name, 1);
                }
                return map;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("Universal-Dyeing-Recipes-Single", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (BaseRecipe recipe : MoreRecipesTweak.this.baseRecipes) {
                    if (!(recipe instanceof UniversalDyeing)) continue;
                    ConfigurationSection section = MoreRecipesTweak.this.recipeFile.getConfigurationSection(recipe.name);
                    if (section.getBoolean("bed.single")) {
                        map.put("bed", 1);
                    }
                    if (section.getBoolean("wool.single")) {
                        map.put("wool", 1);
                    }
                    if (section.getBoolean("carpet.single")) {
                        map.put("carpet", 1);
                    }
                    if (section.getBoolean("concrete.single")) {
                        map.put("concrete", 1);
                    }
                    if (section.getBoolean("concrete_powder.single")) {
                        map.put("concrete_powder", 1);
                    }
                    if (section.getBoolean("terracotta")) {
                        map.put("terracotta", 1);
                    }
                    if (section.getBoolean("stained_glass.single")) {
                        map.put("stained_glass", 1);
                    }
                    if (!section.getBoolean("stained_glass_pane.single")) continue;
                    map.put("stained_glass_pane", 1);
                }
                return map;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("Universal-Dyeing-Recipes-Sorounded", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (BaseRecipe recipe : MoreRecipesTweak.this.baseRecipes) {
                    if (!(recipe instanceof UniversalDyeing)) continue;
                    ConfigurationSection section = MoreRecipesTweak.this.recipeFile.getConfigurationSection(recipe.name);
                    if (section.getBoolean("bed.sorounded")) {
                        map.put("bed", 1);
                    }
                    if (section.getBoolean("wool.sorounded")) {
                        map.put("wool", 1);
                    }
                    if (section.getBoolean("carpet.sorounded")) {
                        map.put("carpet", 1);
                    }
                    if (section.getBoolean("concrete.sorounded")) {
                        map.put("concrete", 1);
                    }
                    if (section.getBoolean("concrete_powder.sorounded")) {
                        map.put("concrete_powder", 1);
                    }
                    if (section.getBoolean("terracotta")) {
                        map.put("terracotta", 1);
                    }
                    if (section.getBoolean("stained_glass.sorounded")) {
                        map.put("stained_glass", 1);
                    }
                    if (!section.getBoolean("stained_glass_pane.sorounded")) continue;
                    map.put("stained_glass_pane", 1);
                }
                return map;
            }
        }));
    }
}

