/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.lavabucketcan;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

@Tweak(name="lava-bucket-trash-can")
public class LavaBucketTrashCan
extends BaseTweak
implements Listener {
    @EventHandler
    public void onLavaPickUp(PlayerBucketFillEvent e) {
        ItemStack item = e.getItemStack();
        if (item.getType() != Material.LAVA_BUCKET) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> helpLore = new ArrayList<String>();
        List list = this.getConfig().getStringList("help-lore");
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        for (String string : list) {
            helpLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
        }
        meta.setLore(helpLore);
        item.setItemMeta(meta);
    }

    @EventHandler
    public void onTrashCanUse(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof LavaBucketTrashGui) {
            Inventory inv = e.getView().getTopInventory();
            if (e.getSlot() != 4 && e.isShiftClick()) {
                inv.setItem(4, null);
            }
            if (e.getCurrentItem() != null && e.getCurrentItem().isSimilar(this.plugin.getMiscItems().FILLAR_GLASS)) {
                e.setCancelled(true);
            }
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (!this.hasPermission(player, Permissions.LAVATRASHCAN)) {
            return;
        }
        if (e.getClick() != ClickType.RIGHT || e.getAction() != InventoryAction.SWAP_WITH_CURSOR) {
            return;
        }
        if (e.getCurrentItem() == null || e.getCursor() == null) {
            return;
        }
        if (!(e.getClickedInventory() instanceof PlayerInventory)) {
            return;
        }
        if (this.matchString(e.getCursor().getType().toString(), this.getConfig().getStringList("black-list-materials"))) {
            return;
        }
        if (e.getCurrentItem().getType() != Material.LAVA_BUCKET) {
            return;
        }
        e.setCancelled(true);
        player.setItemOnCursor(null);
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, SoundCategory.PLAYERS, 0.25f, 2.0f + (float)Math.random());
    }

    private class LavaBucketTrashGui
    implements InventoryHolder {
        private Inventory inventory;
        private Player player;

        public LavaBucketTrashGui(Player player) {
            this.player = player;
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)9, (String)LavaBucketTrashCan.this.getTweakManager().getMessageManager().getMessageWithoutPrefix("lava-bucket-trash-can-gui"));
            int i = 0;
            while (i < 9) {
                if (i != 4) {
                    this.inventory.setItem(i, Tweakin.getPlugin().getMiscItems().FILLAR_GLASS);
                }
                ++i;
            }
        }

        public void open() {
            this.player.openInventory(this.inventory);
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

