/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.lapisintable;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.lapisintable.LapisData;
import com.github.sachin.tweakin.morepersistentdatatypes.DataType;
import com.github.sachin.tweakin.utils.CustomBlockData;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="lapis-in-table")
public class LapisInTableTweak
extends BaseTweak
implements Listener {
    private Map<Location, LapisData> data = new HashMap<Location, LapisData>();
    private final NamespacedKey key = Tweakin.getKey("lapiscount");
    private final NamespacedKey itemKey = Tweakin.getKey("EnchantingTableItemKey");
    private final NamespacedKey entityItemKey = Tweakin.getKey("EnchantingTableEntityItemKey");
    private final NamespacedKey entityStandItemKey = Tweakin.getKey("EnchantingTableEntityArmorStandItemKey");
    private File lapisFile;
    private Map<Player, Location> invMap = new HashMap<Player, Location>();

    @Override
    public void onLoad() {
        this.lapisFile = new File(String.valueOf(this.getPlugin().getDataFolder().getAbsolutePath()) + "/" + "data/lapis-data.yml");
        this.loadLapisData();
    }

    @Override
    public void register() {
        super.register();
    }

    public void saveLapisData() {
        if (!this.lapisFile.exists()) {
            return;
        }
        YamlConfiguration yml = new YamlConfiguration();
        int i = 0;
        for (Location loc : this.data.keySet()) {
            yml.set(String.valueOf(i), (Object)this.data.get(loc));
            ++i;
        }
        try {
            yml.save(this.lapisFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void loadLapisData() {
        if (this.data == null) {
            this.data = new HashMap<Location, LapisData>();
        } else {
            this.data.clear();
        }
        if (this.lapisFile.exists()) {
            YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)this.lapisFile);
            for (String config : yml.getKeys(false)) {
                LapisData d = (LapisData)yml.get(config);
                this.data.put(d.getLocation(), d);
                Chunk chunk = d.getLocation().getChunk();
                boolean loadedChunk = true;
                if (!chunk.isLoaded()) {
                    loadedChunk = chunk.load();
                }
                if (!loadedChunk) continue;
                CustomBlockData blockData = new CustomBlockData(d.getLocation());
                blockData.set(this.key, PersistentDataType.INTEGER, d.getCount());
            }
            this.lapisFile.delete();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onTableClickEvent(PlayerInteractEvent e) {
        ItemStack enchantItem;
        if (e.isCancelled()) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.ENCHANTING_TABLE) {
            return;
        }
        e.setCancelled(true);
        Player player = e.getPlayer();
        Location blockLocation = e.getClickedBlock().getLocation();
        if (this.invMap.values().contains(blockLocation)) {
            e.setCancelled(true);
            return;
        }
        if (this.getBlackListWorlds().contains(blockLocation.getWorld().getName())) {
            return;
        }
        CustomBlockData cdata = new CustomBlockData(blockLocation);
        int count = 0;
        InventoryView view = player.openEnchanting(blockLocation, true);
        if (cdata.has(this.key, PersistentDataType.INTEGER)) {
            count = (Integer)cdata.get(this.key, PersistentDataType.INTEGER);
        }
        if (cdata.has(this.itemKey, DataType.ITEM_STACK) && this.getConfig().getBoolean("store-item") && (enchantItem = cdata.get(this.itemKey, DataType.ITEM_STACK)) != null && !enchantItem.getType().isAir()) {
            view.getTopInventory().setItem(0, enchantItem);
            if (!this.hasEnchantItem(cdata)) {
                this.spawnEnchantItem(cdata, enchantItem);
            } else {
                this.updateEnchantItem(cdata, enchantItem);
            }
        }
        view.getTopInventory().setItem(1, new ItemStack(Material.LAPIS_LAZULI, count));
        this.invMap.put(player, blockLocation);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClose(InventoryCloseEvent e) {
        if (e.getInventory().getType() != InventoryType.ENCHANTING) {
            return;
        }
        Player player = (Player)e.getPlayer();
        if (this.invMap.containsKey(player)) {
            int count = 0;
            Inventory enchantInv = e.getView().getTopInventory();
            CustomBlockData data = new CustomBlockData(this.invMap.get(player));
            if (enchantInv.getItem(1) != null) {
                count = enchantInv.getItem(1).clone().getAmount();
                enchantInv.getItem(1).setAmount(0);
            }
            if (this.getConfig().getBoolean("store-item")) {
                ItemStack enchantItem = enchantInv.getItem(0);
                if (enchantItem != null && !enchantItem.getType().isAir()) {
                    data.set(this.itemKey, DataType.ITEM_STACK, enchantItem);
                    if (!this.hasEnchantItem(data)) {
                        this.spawnEnchantItem(data, enchantItem);
                    } else {
                        this.updateEnchantItem(data, enchantItem);
                    }
                    enchantItem.setAmount(0);
                } else {
                    data.set(this.itemKey, DataType.ITEM_STACK, new ItemStack(Material.AIR));
                    this.removeEnchantItem(data);
                }
            }
            data.set(this.key, PersistentDataType.INTEGER, count);
            this.invMap.remove(player);
        }
    }

    @EventHandler
    public void onEnchantItemEvent(final EnchantItemEvent e) {
        Item item;
        CustomBlockData data;
        Player player = e.getEnchanter();
        if (this.invMap.containsKey(player) && this.getConfig().getBoolean("store-item") && this.hasEnchantItem(data = new CustomBlockData(this.invMap.get(player))) && (item = (Item)Bukkit.getEntity((UUID)UUID.fromString((String)data.get(this.entityItemKey, PersistentDataType.STRING)))) != null) {
            new BukkitRunnable(){

                public void run() {
                    ItemStack enchantItem = e.getInventory().getItem(0);
                    if (enchantItem != null && !enchantItem.getType().isAir()) {
                        item.setItemStack(enchantItem);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 2L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockBreakEvent(BlockBreakEvent e) {
        Location loc = e.getBlock().getLocation();
        if (this.invMap.values().contains(loc)) {
            e.setCancelled(true);
            return;
        }
        CustomBlockData data = new CustomBlockData(loc);
        if (data.has(this.key, PersistentDataType.INTEGER)) {
            if ((Integer)data.get(this.key, PersistentDataType.INTEGER) > 0) {
                ItemStack lapis = new ItemStack(Material.LAPIS_LAZULI, ((Integer)data.get(this.key, PersistentDataType.INTEGER)).intValue());
                loc.getWorld().dropItemNaturally(loc, lapis);
            }
            data.remove(this.key);
        }
        if (data.has(this.itemKey, DataType.ITEM_STACK)) {
            ItemStack item = data.get(this.itemKey, DataType.ITEM_STACK);
            if (!item.getType().isAir()) {
                loc.getWorld().dropItemNaturally(loc, item);
            }
            data.remove(this.itemKey);
            this.removeEnchantItem(data);
        }
    }

    private void spawnEnchantItem(CustomBlockData data, ItemStack item) {
        if (item == null || item.getType().isAir()) {
            return;
        }
        Location loc = data.getLocation();
        Item itemEn = (Item)loc.getWorld().spawn(loc, Item.class);
        itemEn.setItemStack(item);
        itemEn.setPickupDelay(Integer.MAX_VALUE);
        itemEn.getPersistentDataContainer().set(this.entityItemKey, PersistentDataType.INTEGER, (Object)1);
        ArmorStand stand = (ArmorStand)loc.getWorld().spawn(loc.add(0.5, 1.2, 0.5), ArmorStand.class);
        stand.setMarker(true);
        stand.setVisible(false);
        stand.addPassenger((Entity)itemEn);
        data.set(this.entityItemKey, PersistentDataType.STRING, itemEn.getUniqueId().toString());
        data.set(this.entityStandItemKey, PersistentDataType.STRING, stand.getUniqueId().toString());
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent e) {
        if (e.getEntity().getPersistentDataContainer().has(this.entityItemKey, PersistentDataType.INTEGER)) {
            e.setCancelled(true);
        }
    }

    private void removeEnchantItem(CustomBlockData data) {
        Entity stand;
        Entity item;
        if (data.has(this.entityItemKey, PersistentDataType.STRING) && (item = Bukkit.getEntity((UUID)UUID.fromString((String)data.get(this.entityItemKey, PersistentDataType.STRING)))) != null) {
            item.remove();
            data.remove(this.entityItemKey);
        }
        if (data.has(this.entityStandItemKey, PersistentDataType.STRING) && (stand = Bukkit.getEntity((UUID)UUID.fromString((String)data.get(this.entityStandItemKey, PersistentDataType.STRING)))) != null) {
            stand.remove();
            data.remove(this.entityStandItemKey);
        }
    }

    private void updateEnchantItem(CustomBlockData data, ItemStack updatedItem) {
        if (!this.hasEnchantItem(data)) {
            this.spawnEnchantItem(data, updatedItem);
            return;
        }
        Item item = (Item)Bukkit.getEntity((UUID)UUID.fromString((String)data.get(this.entityItemKey, PersistentDataType.STRING)));
        ArmorStand stand = (ArmorStand)Bukkit.getEntity((UUID)UUID.fromString((String)data.get(this.entityStandItemKey, PersistentDataType.STRING)));
        if (item != null && !item.isDead()) {
            stand.removePassenger((Entity)item);
            item.setItemStack(updatedItem);
            stand.addPassenger((Entity)item);
        }
    }

    private boolean hasEnchantItem(CustomBlockData data) {
        return data.has(this.entityItemKey, PersistentDataType.STRING) && data.has(this.entityStandItemKey, PersistentDataType.STRING);
    }

    @Override
    public void onDisable() {
        this.saveLapisData();
    }
}

