/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.jumpyboats;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.jumpyboats.JumpyBoatsTweak;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SteerBoatPacketListener
extends PacketAdapter {
    private final JumpyBoatsTweak instance;
    private final Map<UUID, Integer> cooldowns = new HashMap<UUID, Integer>();

    public SteerBoatPacketListener(JumpyBoatsTweak instance) {
        super((Plugin)Tweakin.getPlugin(), new PacketType[]{PacketType.Play.Client.STEER_VEHICLE});
        this.instance = instance;
    }

    public void onPacketReceiving(PacketEvent e) {
        PacketContainer packet = e.getPacket();
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (player.isInsideVehicle() && player.getVehicle() instanceof Boat) {
            final Boat boat = (Boat)player.getVehicle();
            boolean isJumping = (Boolean)packet.getBooleans().read(0) != false && (boat.isOnGround() || boat.isInWater());
            boolean isUnmount = (Boolean)packet.getBooleans().read(1);
            if (isUnmount) {
                this.cooldowns.remove(uuid);
                return;
            }
            int i = this.cooldowns.getOrDefault(uuid, 0);
            if (i == 0) {
                if (isJumping && !this.instance.containsWorld(player.getWorld())) {
                    new BukkitRunnable(){

                        public void run() {
                            boat.setVelocity(boat.getVelocity().clone().add(new Vector(0.0, SteerBoatPacketListener.this.instance.getConfig().getDouble("jump-modifier"), 0.0)));
                        }
                    }.runTaskLater(this.plugin, 0L);
                    this.cooldowns.put(uuid, this.instance.getConfig().getInt("cooldown"));
                }
            } else {
                this.cooldowns.put(uuid, --i);
            }
        }
    }
}

