/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.customportals;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.inventory.EquipmentSlot;

@Tweak(name="custom-shaped-portals")
public class CustomPortalTweak
extends BaseTweak
implements Listener {
    private List<Material> getValidPortalMaterials() {
        List names = this.getConfig().getStringList("valid-portal-blocks");
        ArrayList<Material> mats = new ArrayList<Material>();
        for (String string : names) {
            if (Material.matchMaterial((String)string) == null) continue;
            mats.add(Material.matchMaterial((String)string));
        }
        return mats;
    }

    @EventHandler
    public void netherPortalLitEvent(PlayerInteractEvent e) {
        if (this.getBlackListWorlds().contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getItem() == null) {
            return;
        }
        if (e.getClickedBlock() == null) {
            return;
        }
        if (e.getItem().getType() != Material.FLINT_AND_STEEL) {
            return;
        }
        Player player = e.getPlayer();
        if (player.getWorld().getEnvironment() == World.Environment.THE_END) {
            return;
        }
        if (!this.hasPermission(player, Permissions.CUSTOMPORTAL_USE)) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        List<Material> validPortalMaterials = this.getValidPortalMaterials();
        if (!validPortalMaterials.contains(e.getClickedBlock().getType())) {
            return;
        }
        if (clickedBlock.getRelative(e.getBlockFace()).getType() != Material.AIR) {
            return;
        }
        boolean facingEast = player.getFacing() == BlockFace.EAST || player.getFacing() == BlockFace.WEST;
        HashSet<Block> checked = new HashSet<Block>();
        BlockFace[] faces = this.getRelativeBlockFaces(facingEast);
        Block block = clickedBlock.getRelative(e.getBlockFace());
        PortalBounds bounds = new PortalBounds(block.getLocation(), facingEast);
        World world = player.getWorld();
        if (this.checkBlock(block, validPortalMaterials, checked, faces, bounds)) {
            e.setCancelled(true);
            this.buildPortal(checked, facingEast, world, player);
            return;
        }
        facingEast = !facingEast;
        bounds = new PortalBounds(block.getLocation(), facingEast);
        faces = this.getRelativeBlockFaces(facingEast);
        checked.clear();
        if (this.checkBlock(block, validPortalMaterials, checked, faces, bounds)) {
            e.setCancelled(true);
            this.buildPortal(checked, facingEast, world, player);
            return;
        }
    }

    private boolean checkBlock(Block block, List<Material> validPortalMaterials, Set<Block> checked, BlockFace[] faces, PortalBounds bounds) {
        if (validPortalMaterials.contains(block.getType()) || checked.contains(block)) {
            return true;
        }
        if (block.getType() != Material.AIR && block.getType() != Material.FIRE) {
            return false;
        }
        checked.add(block);
        if (bounds.updateBounds(block.getLocation()) && !bounds.withinBounds()) {
            return false;
        }
        return this.checkBlock(block.getRelative(faces[2]), validPortalMaterials, checked, faces, bounds) && this.checkBlock(block.getRelative(faces[1]), validPortalMaterials, checked, faces, bounds) && this.checkBlock(block.getRelative(faces[3]), validPortalMaterials, checked, faces, bounds) && this.checkBlock(block.getRelative(faces[0]), validPortalMaterials, checked, faces, bounds);
    }

    private void buildPortal(Set<Block> portalBlocks, boolean facingEast, World world, Player creator) {
        ArrayList<BlockState> blocks = new ArrayList<BlockState>();
        for (Block b : portalBlocks) {
            b.setType(Material.NETHER_PORTAL);
            BlockData bd = b.getBlockData();
            Orientable orientable = (Orientable)bd;
            orientable.setAxis(facingEast ? Axis.Z : Axis.X);
            b.setBlockData((BlockData)orientable);
            blocks.add(b.getState());
        }
        PortalCreateEvent event = new PortalCreateEvent(blocks, world, (Entity)creator, PortalCreateEvent.CreateReason.FIRE);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            for (BlockState b : blocks) {
                b.setType(Material.AIR);
            }
        }
    }

    private BlockFace[] getRelativeBlockFaces(boolean facingEast) {
        return new BlockFace[]{BlockFace.UP, facingEast ? BlockFace.SOUTH : BlockFace.EAST, BlockFace.DOWN, facingEast ? BlockFace.NORTH : BlockFace.WEST};
    }

    private class PortalBounds {
        int minX;
        int maxX;
        int minY;
        int maxY;
        boolean facingEast;
        int maxWidth;
        int maxHeight;
        int maxSize;

        public PortalBounds(Location loc, boolean facingEast) {
            this.maxWidth = CustomPortalTweak.this.getConfig().getInt("max-width", 20);
            this.maxHeight = CustomPortalTweak.this.getConfig().getInt("max-width", 40);
            this.maxSize = this.maxWidth * this.maxHeight;
            this.facingEast = facingEast;
            this.minX = facingEast ? loc.getBlockZ() : loc.getBlockX();
            this.maxX = facingEast ? loc.getBlockZ() : loc.getBlockX();
            this.minY = loc.getBlockY();
            this.maxY = loc.getBlockY();
        }

        public boolean updateBounds(Location loc) {
            boolean valueChanged = false;
            int curX = this.facingEast ? loc.getBlockZ() : loc.getBlockX();
            int curY = loc.getBlockY();
            if (curX < this.minX) {
                this.minX = curX;
                valueChanged = true;
            }
            if (curX >= this.maxX) {
                this.maxX = curX;
                valueChanged = true;
            }
            if (curY < this.minY) {
                this.minY = curY;
                valueChanged = true;
            }
            if (curY >= this.maxY) {
                this.maxY = curY;
                valueChanged = true;
            }
            return valueChanged;
        }

        public boolean withinBounds() {
            if (this.maxX - this.minX > this.maxWidth) {
                return false;
            }
            return this.maxY - this.minY <= this.maxHeight;
        }
    }
}

