/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.compassworkeverywhere;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="compass-work-everywhere")
public class CompassEveryWhereTweak
extends BaseTweak
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onSetBedSpawn(PlayerInteractEvent e) {
        final Player player = e.getPlayer();
        if (!this.hasPermission(player, Permissions.COMPASSTRACK)) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!e.getClickedBlock().getType().toString().endsWith("BED")) {
            return;
        }
        if (e.getItem() == null) {
            return;
        }
        if (!e.getItem().isSimilar(new ItemStack(Material.COMPASS))) {
            return;
        }
        if (this.getBlackListWorlds().contains(player.getLocation().getWorld().getName())) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Location loc;
                if (player.isOnline() && (loc = player.getBedSpawnLocation()) != null) {
                    player.setCompassTarget(loc);
                }
            }
        }.runTaskLater((Plugin)this.getPlugin(), 3L);
    }

    @EventHandler
    public void onPortalEvent(PlayerPortalEvent e) {
        Location loc2 = e.getTo();
        Player player = e.getPlayer();
        if (!player.hasPermission("tweakin.compasstrack")) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null) {
            return;
        }
        if (!item.isSimilar(new ItemStack(Material.COMPASS))) {
            return;
        }
        if (this.getBlackListWorlds().contains(loc2.getWorld().getName())) {
            return;
        }
        CompassMeta meta = (CompassMeta)item.getItemMeta();
        meta.setLodestoneTracked(false);
        meta.setLodestone(loc2);
        if (this.getConfig().getBoolean("nether", true) && loc2.getWorld().getEnvironment() == World.Environment.NETHER) {
            item.setItemMeta((ItemMeta)meta);
        } else if (this.getConfig().getBoolean("end", true) && loc2.getWorld().getEnvironment() == World.Environment.THE_END) {
            item.setItemMeta((ItemMeta)meta);
        }
    }
}

