/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterrecoverycompass;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CartographyInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="better-recovery-compass")
public class BetterRecoveryCompassTweak
extends BaseTweak
implements Listener {
    @Config(key="zoom")
    private int scale = 2;
    @Config(key="show-biome-preview")
    private boolean biomepreview = true;

    private void generateMap(Player player, CartographyInventory inv) {
        ItemStack map = inv.getItem(1);
        ItemStack compass = inv.getItem(0);
        if (map != null && map.getType() == Material.MAP && compass != null && compass.getType() == Material.RECOVERY_COMPASS) {
            Location loc;
            compass = compass.clone();
            if (player.getLastDeathLocation() != null && (loc = player.getLastDeathLocation()).getWorld().getUID() == player.getWorld().getUID()) {
                inv.setItem(2, this.getPlugin().getNmsHelper().createMap(loc, (byte)this.scale, this.biomepreview));
            }
        }
    }

    @EventHandler
    public void cartographyInvClickEvent(InventoryClickEvent e) {
        if (e.getInventory().getType() != InventoryType.CARTOGRAPHY) {
            return;
        }
        final Player player = (Player)e.getWhoClicked();
        if (!this.hasPermission(player, Permissions.BETTERRECOVERYCOMPASS_USE)) {
            return;
        }
        final CartographyInventory inv = (CartographyInventory)e.getInventory();
        ItemStack compass = e.getCursor();
        ItemStack slotCompass = inv.getItem(0);
        if (compass != null && compass.getType() == Material.RECOVERY_COMPASS && e.getSlot() == 0 && (slotCompass == null || slotCompass.getType() == Material.AIR)) {
            compass = compass.clone();
            e.setCancelled(true);
            e.getCursor().setAmount(0);
            inv.setItem(0, compass);
        }
        new BukkitRunnable(){

            public void run() {
                BetterRecoveryCompassTweak.this.generateMap(player, inv);
            }
        }.runTaskLater((Plugin)this.getPlugin(), 1L);
    }
}

