/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterladder;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.TConstants;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

@Tweak(name="better-ladder")
public class BetterLadderTweak
extends BaseTweak
implements Listener {
    @EventHandler
    public void ladderClickEvent(PlayerInteractEvent e) {
        if (this.getBlackListWorlds().contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getClickedBlock().getType() != Material.LADDER) {
            return;
        }
        Player player = e.getPlayer();
        Block clickedLadder = e.getClickedBlock();
        if (player.getPersistentDataContainer().has(TConstants.COMBATX_TAG_KEY, PersistentDataType.INTEGER)) {
            return;
        }
        if (e.getItem() == null) {
            Block downBlock;
            if (!this.hasPermission(player, Permissions.BETTERLADDER_QUICKCLIMB) || !this.getConfig().getBoolean("quickclimb", true)) {
                return;
            }
            if (!player.isSneaking()) {
                return;
            }
            Vector face = player.getEyeLocation().getDirection().clone();
            if (clickedLadder.getRelative(BlockFace.DOWN).getType() != Material.LADDER) {
                Block topBlock = this.getFirstNonLadderBlock(clickedLadder, BlockFace.UP);
                if (topBlock != null && topBlock.getRelative(BlockFace.UP).getType() == Material.AIR) {
                    player.teleport(topBlock.getLocation().setDirection(face).subtract(-0.5, 1.0, -0.5));
                    player.playSound(player.getLocation(), Sound.BLOCK_LADDER_STEP, 1.0f, 1.0f);
                }
            } else if (clickedLadder.getRelative(BlockFace.UP).getType() != Material.LADDER && (downBlock = this.getFirstNonLadderBlock(clickedLadder, BlockFace.DOWN)) != null) {
                player.teleport(downBlock.getLocation().setDirection(face).add(0.5, 1.0, 0.5));
                player.playSound(player.getLocation(), Sound.BLOCK_LADDER_STEP, 1.0f, 1.0f);
            }
        } else if (e.getItem().getType() == Material.LADDER) {
            if (!this.hasPermission(player, Permissions.BETTERLADDER_DROPDOWN) || !this.getConfig().getBoolean("dropdown", true)) {
                return;
            }
            Block downLadder = this.getLadderBlock(clickedLadder);
            if (downLadder == null) {
                return;
            }
            if (downLadder.getType() == Material.AIR) {
                if (this.plugin.griefCompat != null && !this.plugin.griefCompat.canBuild(player, downLadder.getLocation(), Material.LADDER)) {
                    return;
                }
                player.swingMainHand();
                downLadder.getLocation().getBlock().setType(Material.LADDER);
                downLadder.getLocation().getBlock().setBlockData(e.getClickedBlock().getBlockData());
                ItemStack ladder = player.getInventory().getItemInMainHand();
                player.getWorld().playSound(downLadder.getLocation(), Sound.BLOCK_LADDER_PLACE, 1.0f, 1.0f);
                if (player.getGameMode() != GameMode.CREATIVE) {
                    ladder.setAmount(ladder.getAmount() - 1);
                }
            }
        }
    }

    private Block getFirstNonLadderBlock(Block block, BlockFace direction) {
        Block upBlock = block.getRelative(direction);
        if (upBlock.getType() == Material.LADDER) {
            return this.getFirstNonLadderBlock(upBlock, direction);
        }
        if (upBlock.getType() == Material.AIR) {
            return upBlock;
        }
        if (direction == BlockFace.DOWN) {
            return upBlock;
        }
        return null;
    }

    private Block getLadderBlock(Block clickedBlock) {
        Block downBlock = clickedBlock.getRelative(BlockFace.DOWN);
        if (downBlock.getType() == Material.AIR) {
            return downBlock;
        }
        if (downBlock.getType() == Material.LADDER) {
            return this.getLadderBlock(downBlock);
        }
        return null;
    }
}

