/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterarmorstands;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.betterarmorstands.ASGuiHolder;
import com.github.sachin.tweakin.modules.betterarmorstands.BetterArmorStandTweak;
import com.github.sachin.tweakin.modules.betterarmorstands.PresetPose;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.github.sachin.tweakin.utils.ItemBuilder;
import com.github.sachin.tweakin.utils.MiscItems;
import com.github.sachin.tweakin.utils.TConstants;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PresetPoseGui
implements InventoryHolder {
    protected int page = 0;
    protected int maxItemsPerPage = 28;
    protected int index = 0;
    private Inventory inventory;
    private List<ItemStack> items;
    private Player player;
    private ArmorStand as;
    private BetterArmorStandTweak instance = (BetterArmorStandTweak)Tweakin.getPlugin().getTweakManager().getTweakFromName("better-armorstands");
    private MiscItems miscItems = this.instance.getPlugin().getMiscItems();

    public PresetPoseGui(Player player, ArmorStand as) {
        this.player = player;
        this.as = as;
        ArrayList<ItemStack> i = new ArrayList<ItemStack>();
        for (PresetPose pose : this.instance.getPoseManager().getPoses().values()) {
            i.add(pose.item);
        }
        this.items = i;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void handlePageClicks(InventoryClickEvent e) {
        e.setCancelled(true);
        if (e.getCurrentItem() == null) {
            return;
        }
        this.handleMiscClicks(e);
        NBTItem nbti = new NBTItem(e.getCurrentItem());
        if (nbti.hasKey("preset-pose-button")) {
            PresetPose pose = this.instance.getPoseManager().getPoses().get(nbti.getString("preset-pose-button"));
            pose.setPose(this.as);
            ASGuiHolder.openGui(this.player, this.as, this.instance);
        }
    }

    public void handleMiscClicks(InventoryClickEvent e) {
        if (ItemBuilder.hasKey(e.getCurrentItem(), "previous-button")) {
            if (this.page != 0) {
                --this.page;
                this.openPage();
            }
        } else if (ItemBuilder.hasKey(e.getCurrentItem(), "next-button")) {
            if (this.index + 1 < this.items.size()) {
                ++this.page;
                this.openPage();
            }
        } else if (ItemBuilder.hasKey(e.getCurrentItem(), "back-button")) {
            ASGuiHolder.openGui(this.player, this.as, this.instance);
        }
    }

    public void openPage() {
        if (this.items.isEmpty()) {
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.instance.getPlugin().getTweakManager().getMessageManager().getMessageWithoutPrefix("armorstand-poses-gui-title"));
        this.setBorderItems();
        this.player.openInventory(this.inventory);
    }

    public void setBorderItems() {
        this.inventory.setItem(45, this.miscItems.FILLAR_GLASS);
        this.inventory.setItem(53, this.miscItems.FILLAR_GLASS);
        this.inventory.setItem(50, this.miscItems.FILLAR_GLASS);
        for (int slot : TConstants.BORDER_SLOTS) {
            this.inventory.setItem(slot, this.miscItems.FILLAR_GLASS);
        }
        this.inventory.setItem(49, this.miscItems.BACK_BUTTON);
        int i = 0;
        while (i < this.maxItemsPerPage) {
            this.index = this.maxItemsPerPage * this.page + i;
            if (this.index >= this.items.size()) break;
            if (this.items.get(this.index) != null) {
                this.inventory.setItem(this.inventory.firstEmpty(), this.items.get(this.index));
            }
            ++i;
        }
        if (this.page != 0) {
            this.inventory.setItem(45, this.miscItems.PREVIOUS_BUTTON);
        }
        if (this.items.size() > this.maxItemsPerPage) {
            this.inventory.setItem(53, this.miscItems.NEXT_BUTTON);
        }
    }
}

