/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterarmorstands;

import com.github.sachin.tweakin.modules.betterarmorstands.BetterArmorStandTweak;
import com.github.sachin.tweakin.modules.betterarmorstands.PresetPose;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.util.EulerAngle;

public class PoseManager {
    private BetterArmorStandTweak instance;
    private File file;
    private final Gson gson = new Gson();
    private final Map<String, PresetPose> poses = new HashMap<String, PresetPose>();

    public PoseManager(BetterArmorStandTweak instance) {
        this.instance = instance;
        this.loadFile();
    }

    protected void loadPoses() {
        this.instance.getPlugin().getLogger().info("Loading Poses...");
        this.poses.clear();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileReader reader = new FileReader(this.file);){
                JsonObject obj = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
                if (obj != null) {
                    for (Map.Entry entry : obj.entrySet()) {
                        JsonObject element = ((JsonElement)entry.getValue()).getAsJsonObject();
                        this.poses.put((String)entry.getKey(), new PresetPose(element.get("id").getAsString(), element.get("display").getAsString(), this.fromJson(element.getAsJsonObject("head")), this.fromJson(element.getAsJsonObject("torso")), this.fromJson(element.getAsJsonObject("leftarm")), this.fromJson(element.getAsJsonObject("rightarm")), this.fromJson(element.getAsJsonObject("leftleg")), this.fromJson(element.getAsJsonObject("rightleg"))));
                    }
                }
                this.instance.getPlugin().getLogger().info("Loaded " + String.valueOf(this.poses.size()) + " armor stand poses.");
                this.instance.getPlugin().getCommandManager().getCommandCompletions().registerCompletion("tweakinposes", c -> this.poses.keySet());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPose(PresetPose pose) {
        this.poses.put(pose.id, pose);
        this.instance.getPlugin().getCommandManager().getCommandCompletions().registerCompletion("tweakinposes", c -> this.poses.keySet());
    }

    private EulerAngle fromJson(JsonObject obj) {
        return new EulerAngle(obj.get("x").getAsDouble(), obj.get("y").getAsDouble(), obj.get("z").getAsDouble());
    }

    private JsonObject toJson(EulerAngle angle) {
        JsonObject obj = new JsonObject();
        obj.addProperty("x", (Number)angle.getX());
        obj.addProperty("y", (Number)angle.getY());
        obj.addProperty("z", (Number)angle.getZ());
        return obj;
    }

    protected void savePoses() {
        this.instance.getPlugin().getLogger().info("Saving Poses...");
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter writer = new FileWriter(this.file);){
                JsonObject obj = new JsonObject();
                for (String id : this.poses.keySet()) {
                    JsonObject Jpose = new JsonObject();
                    PresetPose pose = this.poses.get(id);
                    Jpose.addProperty("id", pose.id);
                    Jpose.addProperty("display", pose.display);
                    Jpose.add("head", (JsonElement)this.toJson(pose.head));
                    Jpose.add("torso", (JsonElement)this.toJson(pose.torso));
                    Jpose.add("leftarm", (JsonElement)this.toJson(pose.leftarm));
                    Jpose.add("rightarm", (JsonElement)this.toJson(pose.rightarm));
                    Jpose.add("leftleg", (JsonElement)this.toJson(pose.leftleg));
                    Jpose.add("rightleg", (JsonElement)this.toJson(pose.rightleg));
                    obj.add(id, (JsonElement)Jpose);
                }
                this.gson.toJson((JsonElement)obj, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, PresetPose> getPoses() {
        return this.poses;
    }

    private void loadFile() {
        this.file = new File(this.instance.getPlugin().getDataFolder(), "preset-poses.json");
        if (!this.file.exists()) {
            this.instance.getPlugin().saveResource("preset-poses.json", false);
        }
    }
}

