/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterarmorstands;

import com.github.sachin.tweakin.Message;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.acf.BaseCommand;
import com.github.sachin.tweakin.acf.annotation.CommandAlias;
import com.github.sachin.tweakin.acf.annotation.CommandCompletion;
import com.github.sachin.tweakin.acf.annotation.Default;
import com.github.sachin.tweakin.modules.betterarmorstands.ASGuiHolder;
import com.github.sachin.tweakin.modules.betterarmorstands.BetterArmorStandTweak;
import com.github.sachin.tweakin.utils.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.util.RayTraceResult;

public class ArmorStandCommand
extends BaseCommand {
    private BetterArmorStandTweak instance;
    private final Tweakin plugin = Tweakin.getPlugin();

    public ArmorStandCommand(BetterArmorStandTweak instance) {
        this.instance = instance;
        this.plugin.replacements.addReplacement("tweakinarmorstandcommand", instance.getConfig().getString("alias", "as|armorstand"));
    }

    @Default
    @CommandAlias(value="%tweakinarmorstandcommand")
    @CommandCompletion(value="last|near")
    public void onCommand(Player player, String[] args) {
        if (this.instance.getBlackListWorlds().contains(player.getWorld().getName())) {
            return;
        }
        Message messageManager = this.instance.getTweakManager().getMessageManager();
        if (!this.instance.hasPermission(player, Permissions.BETTERARMORSTAND_COMMAND)) {
            player.sendMessage(messageManager.getMessage("no-permission"));
            return;
        }
        if (args.length == 0) {
            RayTraceResult result = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 5.0, entity -> entity instanceof ArmorStand);
            if (result != null && result.getHitEntity() != null) {
                ArmorStand as = (ArmorStand)result.getHitEntity();
                if (this.instance.isItemsAdderArmorStand(as)) {
                    return;
                }
                if (this.canBuild(player, as)) {
                    ASGuiHolder.openGui(player, as, this.instance);
                }
            } else {
                player.sendMessage(messageManager.getMessage("look-at-armorstand"));
            }
        } else if (args.length == 1) {
            if (args[0].equalsIgnoreCase("near")) {
                this.instance.openArmorStandNear(player);
            } else if (args[0].equalsIgnoreCase("last")) {
                this.instance.openArmorStandLast(player);
            }
        }
    }

    private boolean canBuild(Player player, ArmorStand as) {
        PlayerInteractEntityEvent event = new PlayerInteractEntityEvent(player, (Entity)as);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }
}

