/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.manager;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Message;
import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.manager.FirstInstallListener;
import com.github.sachin.tweakin.modules.anvilrepair.AnvilRepairTweak;
import com.github.sachin.tweakin.modules.armoredelytra.ArmoredElytraTweak;
import com.github.sachin.tweakin.modules.autorecipeunlock.AutoRecipeUnlockTweak;
import com.github.sachin.tweakin.modules.betterarmorstands.BetterArmorStandTweak;
import com.github.sachin.tweakin.modules.betterbonemeal.BetterBoneMealTweak;
import com.github.sachin.tweakin.modules.betterflee.AnimalFleeTweak;
import com.github.sachin.tweakin.modules.bettergrindstone.BetterGrindStoneTweak;
import com.github.sachin.tweakin.modules.betterladder.BetterLadderTweak;
import com.github.sachin.tweakin.modules.betterrecoverycompass.BetterRecoveryCompassTweak;
import com.github.sachin.tweakin.modules.bettersignedit.BetterSignEditTweak;
import com.github.sachin.tweakin.modules.bossspawnsounds.BroadCastSoundTweak;
import com.github.sachin.tweakin.modules.bottledcloud.BottledCloudItem;
import com.github.sachin.tweakin.modules.burnvinetip.BurnVineTipTweak;
import com.github.sachin.tweakin.modules.cauldronconcrete.CauldronConcreteTweak;
import com.github.sachin.tweakin.modules.chickenshearing.ChickenShearingTweak;
import com.github.sachin.tweakin.modules.compassworkeverywhere.CompassEveryWhereTweak;
import com.github.sachin.tweakin.modules.confetticreepers.ConfettiCreepers;
import com.github.sachin.tweakin.modules.coordinatehud.CoordinateHUDTweak;
import com.github.sachin.tweakin.modules.craftingtableonstick.CraftTableOnStick;
import com.github.sachin.tweakin.modules.customportals.CustomPortalTweak;
import com.github.sachin.tweakin.modules.elytrabombing.ElytraBombingTweak;
import com.github.sachin.tweakin.modules.fastleafdecay.FastLeafDecayTweak;
import com.github.sachin.tweakin.modules.hoeharvesting.HoeHarvestingTweak;
import com.github.sachin.tweakin.modules.infinitefirework.InfiniteFireworkItem;
import com.github.sachin.tweakin.modules.infinitybucket.InfinityWaterBucketTweak;
import com.github.sachin.tweakin.modules.jumpyboats.JumpyBoatsTweak;
import com.github.sachin.tweakin.modules.lapisintable.LapisInTableTweak;
import com.github.sachin.tweakin.modules.lavabucketcan.LavaBucketTrashCan;
import com.github.sachin.tweakin.modules.lecternpagereset.LecternPageResetTweak;
import com.github.sachin.tweakin.modules.mobheads.MobHeadsTweak;
import com.github.sachin.tweakin.modules.morerecipes.MoreRecipesTweak;
import com.github.sachin.tweakin.modules.netherportalcoords.NetherPortalCoordsTweak;
import com.github.sachin.tweakin.modules.noteblock.NoteBlockHeadsTweak;
import com.github.sachin.tweakin.modules.patdogs.PatDogTweak;
import com.github.sachin.tweakin.modules.poisonpotatousage.PoisonPotatoUsageTweak;
import com.github.sachin.tweakin.modules.reacharound.ReachAroundTweak;
import com.github.sachin.tweakin.modules.recyclablewax.RecyclableWaxTweak;
import com.github.sachin.tweakin.modules.rightclickarmor.RightClickArmor;
import com.github.sachin.tweakin.modules.rotationwrench.RotationWrenchItem;
import com.github.sachin.tweakin.modules.shearitemframe.ShearItemFrameTweak;
import com.github.sachin.tweakin.modules.shearnametag.ShearNameTagTweak;
import com.github.sachin.tweakin.modules.shulkerboxpreview.ShulkerBoxPreview;
import com.github.sachin.tweakin.modules.silencemobs.SilenceMobsTweak;
import com.github.sachin.tweakin.modules.slimebucket.SlimeInBucket;
import com.github.sachin.tweakin.modules.snowballknockback.SnowBallKnockBackTweak;
import com.github.sachin.tweakin.modules.swingthroughgrass.SwingThroughGrassTweak;
import com.github.sachin.tweakin.modules.trowel.TrowelItem;
import com.github.sachin.tweakin.modules.villagerdeathmessage.VillagerDeathMessageTweak;
import com.github.sachin.tweakin.modules.villagerfollowemerald.VillagerFollowEmraldTweak;
import com.github.sachin.tweakin.modules.waterextinguish.WaterExtinguishTweak;
import com.github.sachin.tweakin.utils.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TweakManager {
    private final Tweakin plugin;
    private Message messageManager;
    private List<BaseTweak> tweakList = new ArrayList<BaseTweak>();
    private List<TweakItem> registeredItems = new ArrayList<TweakItem>();
    private Map<BaseTweak, Boolean> guiMap = new HashMap<BaseTweak, Boolean>();
    private FileConfiguration recipeConfig;

    public TweakManager(Tweakin plugin) {
        this.plugin = plugin;
        this.messageManager = plugin.getMessageManager();
    }

    public void load() {
        this.plugin.getLogger().info("Loading tweakin...");
        this.addCoreTweaks();
        this.sort();
        this.reload(false);
    }

    public void reload() {
        this.plugin.getLogger().info("Reloading tweakin...");
        this.reload(true);
    }

    private void reload(boolean unregister) {
        this.plugin.saveDefaultConfig();
        if (!this.registeredItems.isEmpty()) {
            this.registeredItems.clear();
        }
        int registered = 0;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        File recipeFile = new File(this.plugin.getDataFolder(), "recipes.yml");
        this.plugin.reloadMiscItems();
        if (!recipeFile.exists()) {
            this.plugin.saveResource("recipes.yml", false);
        }
        this.recipeConfig = YamlConfiguration.loadConfiguration((File)recipeFile);
        ConfigUpdater.updateWithoutComments(this.plugin, "recipes.yml", recipeFile);
        try {
            ConfigUpdater.update(this.plugin, "config.yml", configFile, new ArrayList<String>(), unregister);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.plugin.reloadConfig();
        if (unregister) {
            this.plugin.reloadMessageManager();
        }
        this.messageManager = this.plugin.getMessageManager();
        FirstInstallListener listener = new FirstInstallListener();
        if (this.plugin.isFirstInstall) {
            this.plugin.isFirstInstall = false;
            this.sendConsoleMessage("&a-----------Tweakin------------");
            this.sendConsoleMessage("&eThank you for installing &6Tweakin!!");
            this.sendConsoleMessage("&eTweakin is installed on server for the first time..");
            this.sendConsoleMessage("&e&lAll tweaks are disabled by default, they can be enabled by using &6&l/tweakin toggle &e&lingame or &6&l/tweakin toggle [tweak-name] &e&lin console");
            this.sendConsoleMessage("&a------------------------------");
            if (!unregister) {
                this.plugin.getServer().getPluginManager().registerEvents((Listener)listener, (Plugin)this.plugin);
                Bukkit.getOnlinePlayers().forEach(p -> {
                    if (p.isOp()) {
                        this.sendFirstInstallMessage((Player)p);
                        firstInstallListener.flaggedPlayers.add(p.getUniqueId());
                    }
                });
            }
        }
        for (BaseTweak t : this.tweakList) {
            try {
                t.reload();
                if (unregister && t.registered) {
                    t.unregister();
                }
                if (t.shouldEnable()) {
                    t.register();
                    if (t instanceof TweakItem) {
                        this.registeredItems.add((TweakItem)t);
                    }
                    ++registered;
                }
                this.guiMap.put(t, t.shouldEnable());
            }
            catch (Exception e) {
                this.plugin.getLogger().info("Error occured while registering " + t.getName() + " tweak..");
                this.plugin.getLogger().info("Report this error on discord or at spigot page in discussion section.");
                e.printStackTrace();
            }
        }
        if (registered == 0 && !this.plugin.isFirstInstall && this.plugin.getConfig().getBoolean("op-notifications", true)) {
            Bukkit.getOnlinePlayers().forEach(p -> {
                if (p.isOp()) {
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a-----------Tweakin------------"));
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eAll tweaks seems to be disabled, use &6/tw toggle &eor &6/tw &6toggle [tweak-name]"));
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eto enable some!!"));
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cDo not use &6config.yml &cto toggle tweaks"));
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a------------------------------"));
                }
            });
            this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a-----------Tweakin------------\n&eAll tweaks seems to be disabled, use &6/tw toggle &eor &6/tw &6toggle [tweak-name]\n&eto enable some!!\n&cDo not use &6config.yml &cto toggle tweaks\n&a------------------------------"));
        }
        this.plugin.getLogger().info("Registered " + registered + " tweaks successfully");
        Bukkit.getOnlinePlayers().forEach(p -> p.updateCommands());
    }

    private void addCoreTweaks() {
        this.tweakList.add(new ShulkerBoxPreview());
        this.tweakList.add(new NoteBlockHeadsTweak());
        this.tweakList.add(new FastLeafDecayTweak());
        this.tweakList.add(new BetterLadderTweak());
        this.tweakList.add(new LapisInTableTweak());
        this.tweakList.add(new CustomPortalTweak());
        this.tweakList.add(new NetherPortalCoordsTweak());
        this.tweakList.add(new SwingThroughGrassTweak());
        this.tweakList.add(new CoordinateHUDTweak());
        this.tweakList.add(new PoisonPotatoUsageTweak());
        this.tweakList.add(new BurnVineTipTweak());
        this.tweakList.add(new SilenceMobsTweak());
        this.tweakList.add(new RotationWrenchItem());
        this.tweakList.add(new BottledCloudItem());
        this.tweakList.add(new TrowelItem());
        this.tweakList.add(new ConfettiCreepers());
        this.tweakList.add(new LavaBucketTrashCan());
        this.tweakList.add(new SlimeInBucket());
        this.tweakList.add(new PatDogTweak());
        this.tweakList.add(new CompassEveryWhereTweak());
        this.tweakList.add(new HoeHarvestingTweak());
        this.tweakList.add(new AnimalFleeTweak());
        this.tweakList.add(new ShearItemFrameTweak());
        this.tweakList.add(new SnowBallKnockBackTweak());
        this.tweakList.add(new InfinityWaterBucketTweak());
        this.tweakList.add(new MobHeadsTweak());
        this.tweakList.add(new BetterGrindStoneTweak());
        this.tweakList.add(new ArmoredElytraTweak());
        this.tweakList.add(new VillagerDeathMessageTweak());
        this.tweakList.add(new BetterArmorStandTweak());
        this.tweakList.add(new ShearNameTagTweak());
        this.tweakList.add(new LecternPageResetTweak());
        this.tweakList.add(new CraftTableOnStick());
        this.tweakList.add(new InfiniteFireworkItem());
        this.tweakList.add(new MoreRecipesTweak());
        this.tweakList.add(new AutoRecipeUnlockTweak());
        this.tweakList.add(new AnvilRepairTweak());
        this.tweakList.add(new WaterExtinguishTweak());
        this.tweakList.add(new BetterBoneMealTweak());
        this.tweakList.add(new ElytraBombingTweak());
        this.tweakList.add(new ChickenShearingTweak());
        this.tweakList.add(new RecyclableWaxTweak());
        if (this.plugin.isProtocolLibEnabled) {
            if (this.plugin.isPost1_19_3()) {
                this.tweakList.add(new BroadCastSoundTweak());
            }
            this.tweakList.add(new BetterSignEditTweak());
            this.tweakList.add(new ReachAroundTweak());
            this.tweakList.add(new JumpyBoatsTweak());
        } else {
            this.plugin.getLogger().severe("Not running ProtocolLib, ignoring boss-spawn-sounds, better-sign-edit, reach-around, jumpy-boats...");
        }
        if (this.plugin.isRunningPaper) {
            this.tweakList.add(new CauldronConcreteTweak());
            this.tweakList.add(new VillagerFollowEmraldTweak());
        } else {
            this.plugin.getLogger().severe("Not running PaperMC as server software, ignoring cauldron concrete and villager follow emerald tweak...");
        }
        if (this.plugin.isPost1_19()) {
            this.tweakList.add(new BetterRecoveryCompassTweak());
        }
        if (!this.plugin.isPost1_19_3()) {
            this.tweakList.add(new RightClickArmor());
        }
    }

    public List<BaseTweak> getTweakList() {
        return this.tweakList;
    }

    private void sort() {
        TreeMap treeMap = new TreeMap(Comparator.naturalOrder());
        for (BaseTweak tweak : this.tweakList) {
            treeMap.put(tweak.getName(), tweak);
        }
        this.tweakList.clear();
        this.tweakList.addAll(treeMap.values());
    }

    private void sendConsoleMessage(String message) {
        this.plugin.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public void sendFirstInstallMessage(Player player) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a-----------Tweakin------------"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eThank you for installing &6Tweakin!!"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eTweakin is installed on server for the first time.."));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e&lAll tweaks are disabled by default, they can be enabled by using &6&l/tweakin toggle &e&lingame or &6&l/tweakin toggle [tweak-name] &e&lin console"));
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&a------------------------------"));
    }

    public Message getMessageManager() {
        return this.messageManager;
    }

    public List<TweakItem> getRegisteredItems() {
        return this.registeredItems;
    }

    public Map<BaseTweak, Boolean> getGuiMap() {
        return this.guiMap;
    }

    public List<String> getTweakNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (BaseTweak t : this.getTweakList()) {
            list.add(t.getName());
        }
        return list;
    }

    public void addTweak(BaseTweak tweak) {
        this.tweakList.add(tweak);
    }

    public List<String> getRegisteredItemNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (TweakItem i : this.registeredItems) {
            list.add(i.getName());
        }
        return list;
    }

    public TweakItem getTweakItem(String name) {
        for (TweakItem tweakItem : this.registeredItems) {
            if (!tweakItem.getName().equals(name)) continue;
            return tweakItem;
        }
        return null;
    }

    public BaseTweak getTweakFromName(String name) {
        for (BaseTweak tweak : this.getTweakList()) {
            if (!tweak.getName().equals(name)) continue;
            return tweak;
        }
        return null;
    }

    public FileConfiguration getRecipeFile() {
        return this.recipeConfig;
    }
}

