/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.gui;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.utils.ItemBuilder;
import com.github.sachin.tweakin.utils.MiscItems;
import com.github.sachin.tweakin.utils.TConstants;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PagedGuiHolder
implements InventoryHolder {
    protected int page = 0;
    protected int maxItemsPerPage = 28;
    protected int index = 0;
    private Tweakin plugin;
    private MiscItems miscItems;
    private Player player;
    private Inventory inventory;
    private List<ItemStack> items = new ArrayList<ItemStack>();

    public PagedGuiHolder(Tweakin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.miscItems = plugin.getMiscItems();
        for (BaseTweak t : plugin.getTweakManager().getTweakList()) {
            if (t.shouldEnable()) {
                this.items.add(this.getModifiedDisplay(t.getName(), this.miscItems.ENABLED_BUTTON));
            } else {
                this.items.add(this.getModifiedDisplay(t.getName(), this.miscItems.DISABLED_BUTTON));
            }
            plugin.getTweakManager().getGuiMap().put(t, t.shouldEnable());
        }
    }

    public ItemStack getModifiedDisplay(String display, ItemStack item) {
        ItemStack cloned = item.clone();
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.YELLOW + display);
        cloned.setItemMeta(meta);
        return cloned;
    }

    public BaseTweak getTweakName(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        String name = meta.getDisplayName();
        return this.plugin.getTweakManager().getTweakFromName(name.replace(ChatColor.YELLOW.toString(), ""));
    }

    public int getMaxItemsPerPage() {
        return this.maxItemsPerPage;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void handlePageClicks(InventoryClickEvent e) {
        e.setCancelled(true);
        if (e.getCurrentItem() == null) {
            return;
        }
        this.handleMiscClicks(e);
        if (ItemBuilder.hasKey(e.getCurrentItem(), "enabled-button")) {
            ItemStack newItem = this.getModifiedDisplay(e.getCurrentItem().getItemMeta().getDisplayName(), this.miscItems.DISABLED_BUTTON);
            this.items.set(this.items.indexOf(e.getCurrentItem()), newItem);
            e.setCurrentItem(newItem);
            BaseTweak t = this.getTweakName(e.getCurrentItem());
            if (t != null) {
                this.plugin.getTweakManager().getGuiMap().put(t, false);
            }
        } else if (ItemBuilder.hasKey(e.getCurrentItem(), "disabled-button")) {
            ItemStack newItem = this.getModifiedDisplay(e.getCurrentItem().getItemMeta().getDisplayName(), this.miscItems.ENABLED_BUTTON);
            this.items.set(this.items.indexOf(e.getCurrentItem()), newItem);
            e.setCurrentItem(newItem);
            BaseTweak t = this.getTweakName(e.getCurrentItem());
            if (t != null) {
                this.plugin.getTweakManager().getGuiMap().put(t, true);
            }
        }
    }

    public void handleMiscClicks(InventoryClickEvent e) {
        if (ItemBuilder.hasKey(e.getCurrentItem(), "previous-button")) {
            if (this.page != 0) {
                --this.page;
                this.openPage();
            }
        } else if (ItemBuilder.hasKey(e.getCurrentItem(), "next-button") && this.index + 1 < this.items.size()) {
            ++this.page;
            this.openPage();
        }
    }

    public void openPage() {
        if (this.items.isEmpty()) {
            return;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)"Tweaks");
        this.setBorderItems();
        this.player.openInventory(this.inventory);
    }

    public void setBorderItems() {
        this.inventory.setItem(45, this.miscItems.FILLAR_GLASS);
        this.inventory.setItem(53, this.miscItems.FILLAR_GLASS);
        this.inventory.setItem(50, this.miscItems.FILLAR_GLASS);
        this.inventory.setItem(49, this.miscItems.INFO_PAPER);
        for (int slot : TConstants.BORDER_SLOTS) {
            this.inventory.setItem(slot, this.miscItems.FILLAR_GLASS);
        }
        int i = 0;
        while (i < this.getMaxItemsPerPage()) {
            this.index = this.getMaxItemsPerPage() * this.page + i;
            if (this.index >= this.items.size()) break;
            if (this.items.get(this.index) != null) {
                this.inventory.setItem(this.inventory.firstEmpty(), this.items.get(this.index));
            }
            ++i;
        }
        if (this.page != 0) {
            this.inventory.setItem(45, this.miscItems.PREVIOUS_BUTTON);
        }
        if (this.items.size() > this.maxItemsPerPage) {
            this.inventory.setItem(53, this.miscItems.NEXT_BUTTON);
        }
    }
}

