/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.commands;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Message;
import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.acf.BaseCommand;
import com.github.sachin.tweakin.acf.annotation.CommandAlias;
import com.github.sachin.tweakin.acf.annotation.CommandCompletion;
import com.github.sachin.tweakin.acf.annotation.Default;
import com.github.sachin.tweakin.acf.annotation.Dependency;
import com.github.sachin.tweakin.acf.annotation.Description;
import com.github.sachin.tweakin.acf.annotation.Subcommand;
import com.github.sachin.tweakin.gui.PagedGuiHolder;
import com.github.sachin.tweakin.modules.betterarmorstands.BetterArmorStandTweak;
import com.github.sachin.tweakin.modules.betterarmorstands.PresetPose;
import com.github.sachin.tweakin.modules.mobheads.Head;
import com.github.sachin.tweakin.utils.annotations.CommandInfo;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.RayTraceResult;

@Description(value="core command for tweakin")
@CommandAlias(value="tw|tweakin")
public class CoreCommand
extends BaseCommand {
    @Dependency
    private Tweakin plugin;
    private Message messageManager;

    @Default
    public void onHelp(CommandSender sender, String[] args) {
        if (args.length == 0 && this.hasPermission(sender, "command.help")) {
            this.onHelp(sender);
        }
    }

    public void onHelp(CommandSender sender) {
        StringBuilder builder = new StringBuilder();
        Message messageManager = this.plugin.getTweakManager().getMessageManager();
        if (sender instanceof Player) {
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)"----------&aTweakin&f----------\n"));
        } else {
            builder.append("\n");
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(messageManager.getPrefix()) + "----------&aTweakin&f----------\n")));
        }
        Method[] methodArray = CoreCommand.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(CommandInfo.class)) {
                CommandInfo info = method.getAnnotation(CommandInfo.class);
                String format = null;
                format = sender instanceof Player ? messageManager.getMessageWithoutPrefix("help-command-format") : messageManager.getMessage("help-command-format");
                String command = format.replace("%syntax%", info.syntax()).replace("%perm%", info.perm()).replace("%description%", info.description());
                builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)command));
                builder.append("\n");
            }
            ++n2;
        }
        if (sender instanceof Player) {
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)"---------------------------"));
        } else {
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(messageManager.getPrefix()) + "---------------------------")));
        }
        sender.sendMessage(builder.toString());
    }

    public CoreCommand(Tweakin plugin) {
        this.plugin = plugin;
        this.messageManager = plugin.getTweakManager().getMessageManager();
    }

    @Subcommand(value="reload")
    @CommandInfo(syntax="&a/tweakin reload", perm="tweakin.command.reload", description="reloads all config files")
    public void onReloadCommand(CommandSender sender) {
        if (!this.hasPermission(sender, "command.reload")) {
            sender.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        this.plugin.getTweakManager().reload();
        sender.sendMessage(this.messageManager.getMessage("reloaded"));
    }

    @Subcommand(value="toggle")
    @CommandCompletion(value="@tweaklist")
    @CommandInfo(syntax="&a/tweakin toggle &7(tweak)", perm="tweakin.command.toggle", description="toggles a tweak if specified or opens a gui")
    public void onConfigureCommand(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "command.toggle")) {
            sender.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        if (args.length == 0 && sender instanceof Player) {
            PagedGuiHolder gui = new PagedGuiHolder(this.plugin, (Player)sender);
            gui.openPage();
        } else if (args.length == 1) {
            BaseTweak t = this.plugin.getTweakManager().getTweakFromName(args[0]);
            if (t != null) {
                if (t.shouldEnable()) {
                    this.plugin.getTweakManager().getGuiMap().put(t, false);
                    sender.sendMessage(this.messageManager.getMessage("tweak-disabled").replace("%tweak%", args[0]));
                } else {
                    this.plugin.getTweakManager().getGuiMap().put(t, true);
                    sender.sendMessage(this.messageManager.getMessage("tweak-enabled").replace("%tweak%", args[0]));
                }
                this.plugin.getTweakManager().reload();
            } else {
                sender.sendMessage(this.messageManager.getMessage("invalid-tweak"));
            }
        }
    }

    @Subcommand(value="tweak-list")
    @CommandInfo(syntax="&a/tweakin tweak-list", perm="tweakin.command.list", description="lists enabled and disabled tweaks")
    public void onList(CommandSender sender) {
        if (!this.hasPermission(sender, "command.list")) {
            sender.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        ArrayList<String> enabled = new ArrayList<String>();
        ArrayList<String> disabled = new ArrayList<String>();
        for (BaseTweak t : this.plugin.getTweakManager().getTweakList()) {
            if (t.registered) {
                enabled.add(t.getName());
                continue;
            }
            disabled.add(t.getName());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append(ChatColor.YELLOW + "--------==Tweak-List==--------\n");
        builder.append(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)("&a&lEnabled Tweaks(" + enabled.size() + ")"))) + "\n");
        for (String s : enabled) {
            builder.append(ChatColor.GREEN + s + ChatColor.RESET + ", ");
        }
        builder.append("\n");
        builder.append(String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)("&c&lDisabled Tweaks(" + disabled.size() + ")"))) + "\n");
        for (String s : disabled) {
            builder.append(ChatColor.RED + s + ChatColor.RESET + ", ");
        }
        builder.append("\n");
        builder.append(ChatColor.YELLOW + "------------------------------");
        sender.sendMessage(builder.toString());
    }

    @Subcommand(value="give")
    @CommandCompletion(value="@players @tweakitems @nothing")
    @CommandInfo(syntax="&a/tweakin give &7[player] [item] (amount)", perm="tweakin.command.give", description="gives specified player a tweakin item")
    public void onGiveCommand(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "command.give")) {
            sender.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        if (args.length < 2) {
            return;
        }
        Player player = Bukkit.getPlayer((String)args[0]);
        TweakItem tItem = this.plugin.getTweakManager().getTweakItem(args[1]);
        if (player == null) {
            sender.sendMessage(this.messageManager.getMessage("invalid-player"));
            return;
        }
        if (tItem == null) {
            sender.sendMessage(this.messageManager.getMessage("invalid-item"));
            return;
        }
        int amount = 1;
        if (args.length == 3) {
            amount = Integer.parseInt(args[2]);
        }
        ItemStack item = tItem.getItem().clone();
        item.setAmount(amount);
        player.getInventory().addItem(new ItemStack[]{item});
        sender.sendMessage(this.messageManager.getMessage("gave-item").replace("%item%", args[1]).replace("%player%", player.getName()));
    }

    @Subcommand(value="givehead")
    @CommandCompletion(value="@players @tweakinheads @nothing")
    @CommandInfo(syntax="&a/tweakin givehead &7[player] [head] (amount)", perm="tweakin.command.givehead", description="gives specified player a mob head")
    public void onGiveHeadCommand(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, "command.givehead")) {
            sender.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        if (!this.plugin.getTweakManager().getTweakFromName((String)"mob-heads").registered) {
            sender.sendMessage(this.messageManager.getMessage("tweak-is-disabled").replace("%tweak%", "mob-heads"));
            return;
        }
        if (args.length < 2) {
            return;
        }
        Player player = Bukkit.getPlayer((String)args[0]);
        Optional oHead = Enums.getIfPresent(Head.class, (String)args[1]);
        if (player == null) {
            sender.sendMessage(this.messageManager.getMessage("invalid-player"));
            return;
        }
        if (args[1].equals("ALL")) {
            Head[] headArray = Head.values();
            int n = headArray.length;
            int n2 = 0;
            while (n2 < n) {
                Head h = headArray[n2];
                player.getLocation().getWorld().dropItemNaturally(player.getLocation(), h.getSkull().clone());
                ++n2;
            }
            return;
        }
        if (!oHead.isPresent()) {
            sender.sendMessage(this.messageManager.getMessage("invalid-item"));
            return;
        }
        int amount = 1;
        if (args.length == 3) {
            amount = Integer.parseInt(args[2]);
        }
        ItemStack item = ((Head)((Object)oHead.get())).getSkull().clone();
        item.setAmount(amount);
        player.getInventory().addItem(new ItemStack[]{item});
        sender.sendMessage(this.messageManager.getMessage("gave-head").replace("%head%", args[1]).replace("%player%", player.getName()));
    }

    @Subcommand(value="addpose")
    @CommandInfo(syntax="&a/tweakin addpose &7[id] [display]", perm="tweakin.command.addpose", description="adds the pose of armorstand you are looking at to list")
    public void onAddPose(Player player, String[] args) {
        if (args.length != 2) {
            return;
        }
        if (!this.hasPermission((CommandSender)player, "command.addpose")) {
            player.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        BetterArmorStandTweak tweak = (BetterArmorStandTweak)this.plugin.getTweakManager().getTweakFromName("better-armorstands");
        if (!tweak.registered) {
            player.sendMessage(this.messageManager.getMessage("tweak-is-disabled").replace("%tweak%", "better-armorstands"));
            return;
        }
        String id = args[0];
        String display = args[1];
        if (tweak.getPoseManager().getPoses().containsKey(id)) {
            player.sendMessage(this.messageManager.getMessage("pose-exists").replace("%pose%", id));
            return;
        }
        RayTraceResult result = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), 5.0, entity -> entity instanceof ArmorStand);
        if (result != null && result.getHitEntity() != null) {
            ArmorStand as = (ArmorStand)result.getHitEntity();
            PresetPose pose = new PresetPose(id, display, as.getHeadPose(), as.getBodyPose(), as.getLeftArmPose(), as.getRightArmPose(), as.getLeftLegPose(), as.getRightLegPose());
            tweak.getPoseManager().addPose(pose);
            player.sendMessage(this.messageManager.getMessage("pose-added"));
        } else {
            player.sendMessage(this.messageManager.getMessage("look-at-armorstand"));
        }
    }

    @Subcommand(value="removepose")
    @CommandInfo(syntax="&a/tweakin removepose &7[pose]", perm="tweakin.command.removepose", description="removes a armorstand pose from list")
    @CommandCompletion(value="@tweakinposes")
    public void onRemovePose(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return;
        }
        if (!this.hasPermission(sender, "command.removepose")) {
            sender.sendMessage(this.messageManager.getMessage("no-permission"));
            return;
        }
        BetterArmorStandTweak tweak = (BetterArmorStandTweak)this.plugin.getTweakManager().getTweakFromName("better-armorstands");
        if (!tweak.registered) {
            sender.sendMessage(this.messageManager.getMessage("tweak-is-disabled").replace("%tweak%", "better-armorstands"));
            return;
        }
        String id = args[0];
        if (tweak.getPoseManager().getPoses().remove(id) != null) {
            sender.sendMessage(this.messageManager.getMessage("pose-removed"));
        }
    }

    @Subcommand(value="help")
    @CommandInfo(syntax="&a/tweakin help", perm="tweakin.command.help", description="shows all tweakin commands, which you are looking at")
    public void onHelpCommand(CommandSender sender, String[] args) {
        if (this.hasPermission(sender, "command.help")) {
            this.onHelp(sender);
        }
    }

    private boolean hasPermission(CommandSender sender, String permission) {
        if (this.plugin.getConfig().getBoolean("check-permissions-for-core-commands")) {
            return sender.hasPermission(permission);
        }
        return sender.isOp();
    }
}

