/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.github.sachin.tweakin.utils.ItemBuilder;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class TweakItem
extends BaseTweak {
    protected ItemStack item;
    private Set<NamespacedKey> registeredRecipes = new HashSet<NamespacedKey>();
    private FileConfiguration recipeConfig;

    @Override
    public void reload() {
        super.reload();
        this.buildItem();
        this.recipeConfig = this.getTweakManager().getRecipeFile();
    }

    public void buildItem() {
        this.item = ItemBuilder.itemFromFile(this.plugin.getMiscItems().CONFIG.getConfigurationSection(this.getName()), this.getName());
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void addRecipe(NamespacedKey key, Recipe recipe) {
        this.registeredRecipes.add(key);
        try {
            Bukkit.addRecipe((Recipe)recipe);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerRecipe() {
        if (!this.getConfig().getBoolean("craftable", true)) {
            return;
        }
        this.unregisterRecipe();
        ConfigurationSection recipes = this.recipeConfig.getConfigurationSection(this.getName());
        if (recipes == null) {
            this.getPlugin().getLogger().info("Could not find recipes for " + this.getName() + " in recipes.yml");
            return;
        }
        if (recipes.getKeys(false) == null) {
            this.getPlugin().getLogger().info("Could not find recipes for " + this.getName() + " in recipes.yml");
            return;
        }
        for (String key : recipes.getKeys(false)) {
            ConfigurationSection recipe = recipes.getConfigurationSection(key);
            String type = recipe.getString("type", "none");
            NamespacedKey recipeKey = Tweakin.getKey(String.valueOf(this.getName()) + "_" + key + "_" + type);
            if (type.equals("shaped") && recipe.contains("keys") && recipe.contains("pattern")) {
                ShapedRecipe shapedRecipe = new ShapedRecipe(recipeKey, this.item.clone());
                List patternList = recipe.getStringList("pattern");
                boolean invalidPattern = false;
                if (patternList.size() > 3) {
                    invalidPattern = true;
                }
                for (String s : patternList) {
                    if (s.length() <= 3) continue;
                    invalidPattern = true;
                }
                if (invalidPattern) continue;
                shapedRecipe.shape(patternList.toArray(new String[0]));
                for (String ing : recipe.getConfigurationSection("keys").getKeys(false)) {
                    RecipeChoice choice = TweakItem.getIngredient(recipe.getString("keys." + ing), recipe.getBoolean("exact", false));
                    if (choice == null) continue;
                    shapedRecipe.setIngredient(ing.charAt(0), choice);
                }
                this.addRecipe(recipeKey, (Recipe)shapedRecipe);
                continue;
            }
            if (!type.equals("shapeless") || !recipe.contains("ingredients")) continue;
            ShapelessRecipe shapelessRecipe = new ShapelessRecipe(recipeKey, this.item.clone());
            for (String ing : recipe.getStringList("ingredients")) {
                RecipeChoice choice = TweakItem.getIngredient(ing, recipe.getBoolean("exact", false));
                if (choice == null) continue;
                shapelessRecipe.addIngredient(choice);
            }
            this.addRecipe(recipeKey, (Recipe)shapelessRecipe);
        }
    }

    public static RecipeChoice getIngredient(String str, boolean exact) {
        if (str == null) {
            return null;
        }
        if (str.contains("|")) {
            List<String> l = Arrays.asList(str.split("\\|"));
            ArrayList<Material> mats = new ArrayList<Material>();
            for (String s : l) {
                Optional opMat2 = Enums.getIfPresent(Material.class, (String)s.toUpperCase());
                if (!opMat2.isPresent()) continue;
                mats.add((Material)opMat2.get());
            }
            return new RecipeChoice.MaterialChoice(mats);
        }
        Optional opMat = Enums.getIfPresent(Material.class, (String)str.toUpperCase());
        if (opMat.isPresent()) {
            if (exact) {
                return new RecipeChoice.ExactChoice(new ItemStack((Material)opMat.get()));
            }
            return new RecipeChoice.MaterialChoice((Material)opMat.get());
        }
        Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)str.toLowerCase()), Material.class);
        if (tag != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ArrayList<Material> mats = new ArrayList<Material>();
            for (Material m : tag.getValues()) {
                items.add(new ItemStack(m));
                mats.add(m);
            }
            if (exact) {
                return new RecipeChoice.ExactChoice(items);
            }
            return new RecipeChoice.MaterialChoice(mats);
        }
        return null;
    }

    public void unregisterRecipe() {
        if (this.registeredRecipes.isEmpty()) {
            return;
        }
        for (NamespacedKey namespacedKey : this.registeredRecipes) {
            Bukkit.removeRecipe((NamespacedKey)namespacedKey);
        }
    }

    public boolean hasItem(Player player, EquipmentSlot slot) {
        ItemStack item = player.getInventory().getItem(slot);
        if (item == null) {
            return false;
        }
        NBTItem nbtItem = new NBTItem(item);
        return nbtItem.hasKey(this.getName());
    }

    public boolean isSimilar(ItemStack item) {
        if (item == null) {
            return false;
        }
        NBTItem nbtItem = new NBTItem(item);
        return nbtItem.hasKey(this.getName());
    }

    protected class UsedItem {
        private ItemStack item;
        private ItemMeta meta;

        public UsedItem(ItemStack item) {
            this.item = item;
            this.meta = item.getItemMeta();
        }

        public int getUses() {
            if (this.meta instanceof Damageable) {
                Damageable damageable = (Damageable)this.meta;
                return damageable.getDamage();
            }
            return -1;
        }

        public void setUses(int value) {
            if (this.meta instanceof Damageable) {
                Damageable damageable = (Damageable)this.meta;
                damageable.setDamage(value);
            }
        }

        public void use() {
            if (this.meta instanceof Damageable) {
                Damageable damageable = (Damageable)this.meta;
                damageable.setDamage(damageable.getDamage() + 1);
            }
        }

        public ItemStack getItem() {
            this.item.setItemMeta(this.meta);
            return this.item;
        }
    }
}

