/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.utils.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;

public class Message {
    private Tweakin plugin;
    private YamlConfiguration messages;

    public Message(Tweakin plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        File file = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!file.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)file);
        try {
            ConfigUpdater.update(this.plugin, "messages.yml", file, new ArrayList<String>(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getMessage(String key) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("prefix", "")) + this.messages.getString(key, "")));
    }

    public String getMessageWithoutPrefix(String key) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString(key, ""));
    }

    public String getPrefix() {
        return this.getMessageWithoutPrefix("prefix");
    }
}

