/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.acf.BaseCommand;
import com.github.sachin.tweakin.manager.TweakManager;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public abstract class BaseTweak {
    protected final Tweakin plugin = Tweakin.getPlugin();
    private TweakManager tweakManager;
    private boolean shouldEnable;
    private ConfigurationSection config;
    private final String configKey = this.getClass().getAnnotation(Tweak.class).name();
    public boolean registered;

    public BaseTweak() {
        this.load();
    }

    protected void load() {
        this.tweakManager = this.plugin.getTweakManager();
        this.config = this.plugin.getConfig().getConfigurationSection(this.configKey);
        if (this.config == null || !this.config.contains("enabled")) {
            this.plugin.getLogger().info("Could not found config section for " + this.configKey + ", ignoring the tweak module..");
            this.shouldEnable = false;
            return;
        }
        this.onLoad();
        this.shouldEnable = this.config.getBoolean("enabled", true);
    }

    public void reload() {
        this.config = this.plugin.getConfig().getConfigurationSection(this.configKey);
        this.shouldEnable = this.config.getBoolean("enabled");
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Config ann = field.getDeclaredAnnotation(Config.class);
            if (ann != null && this.config.contains(ann.key())) {
                try {
                    field.setAccessible(true);
                    Object value = this.config.get(ann.key(), field.get(this));
                    field.set(this, value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
    }

    public BaseTweak getInstance() {
        return this;
    }

    public TweakManager getTweakManager() {
        return this.tweakManager;
    }

    public boolean shouldEnable() {
        return this.shouldEnable;
    }

    public boolean isPluginEnabled(String name) {
        return this.plugin.getServer().getPluginManager().isPluginEnabled(name);
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }

    public String getName() {
        return this.configKey;
    }

    public List<String> getBlackListWorlds() {
        List list;
        if (this.config.contains("black-list-worlds") && (list = this.config.getStringList("black-list-worlds")) != null) {
            return list;
        }
        return new ArrayList<String>();
    }

    public boolean containsWorld(World world) {
        return this.containsWorld(world.getName());
    }

    public boolean containsWorld(String worldName) {
        return this.getBlackListWorlds().contains(worldName);
    }

    public boolean hasPermission(Player player, Permission permission) {
        if (this.config.getBoolean("check-permissions", true)) {
            return player.hasPermission(permission);
        }
        return true;
    }

    public boolean matchString(String str, List<String> matcher) {
        for (String s : matcher) {
            if (s.startsWith("^") && str.startsWith(s.replace("^", ""))) {
                return true;
            }
            if (s.endsWith("$") && str.endsWith(s.replace("$", ""))) {
                return true;
            }
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void swingHand(EquipmentSlot hand, Player player) {
        if (hand == EquipmentSlot.HAND) {
            player.swingMainHand();
        } else if (hand == EquipmentSlot.OFF_HAND) {
            player.swingOffHand();
        }
    }

    public boolean matchTag(Material mat, List<String> matcher) {
        for (String s : matcher) {
            Tag tag = Bukkit.getTag((String)"blocks", (NamespacedKey)NamespacedKey.minecraft((String)s.toLowerCase()), Material.class);
            if (tag == null || !tag.getValues().contains(mat)) continue;
            return true;
        }
        return false;
    }

    protected void registerEvents(Listener listener) {
        this.plugin.getServer().getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }

    protected void unregisterEvents(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
    }

    protected void registerCommands(BaseCommand command) {
        this.plugin.getCommandManager().registerCommand(command);
    }

    protected void unregisterCommands(BaseCommand command) {
        this.plugin.getCommandManager().unregisterCommand(command);
    }

    public Tweakin getPlugin() {
        return this.plugin;
    }

    public void register() {
        if (this instanceof Listener) {
            this.registerEvents((Listener)this);
        }
        this.registered = true;
    }

    public void unregister() {
        if (this instanceof Listener) {
            this.unregisterEvents((Listener)this);
        }
        this.registered = false;
    }

    public void onDisable() {
    }

    public void onLoad() {
    }
}

