/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.WGFlagManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public abstract class BaseFlag {
    private Tweakin plugin;
    private String flagName;
    private StateFlag flag;
    private WGFlagManager manager;

    public BaseFlag(Tweakin plugin, String flagName) {
        this.plugin = plugin;
        this.flagName = flagName;
        this.manager = plugin.getWGFlagManager();
    }

    public void register() {
        this.flag = new StateFlag(this.flagName, this.plugin.getConfig().getBoolean("default-worldguard-flag-value"));
        try {
            this.manager.getRegistry().register((Flag)this.flag);
            this.plugin.getLogger().info("Worldguard flag: " + this.flagName + " registered successfully");
        }
        catch (FlagConflictException e) {
            this.plugin.getLogger().warning("A flag with the name \"" + this.flag.getName() + "\" already exists and could not be registered.");
            e.printStackTrace();
        }
    }

    public String getFlagName() {
        return this.flagName;
    }

    public StateFlag getFlag() {
        return this.flag;
    }

    public boolean queryFlag(Player player) {
        return this.queryFlag(player, player.getLocation());
    }

    public boolean queryFlag(Player player, Location loc) {
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        RegionContainer regionContainer = this.manager.getWGinstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(localPlayer.getWorld());
        ApplicableRegionSet regionSet = regionManager.getApplicableRegions(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()));
        return regionSet.testState((RegionAssociable)localPlayer, new StateFlag[]{this.flag});
    }

    public boolean queryFlag(Location loc) {
        RegionContainer regionContainer = this.manager.getWGinstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(BukkitAdapter.adapt((World)loc.getWorld()));
        ApplicableRegionSet regionSet = regionManager.getApplicableRegions(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ()));
        return regionSet.testState(null, new StateFlag[]{this.flag});
    }
}

