/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectionUtil {
    private static final Table<Class<?>, String, Field> fieldCache = HashBasedTable.create();
    private static final Table<Class<?>, String, Method> methodCache = HashBasedTable.create();

    public static Field getFieldCached(Class<?> clazz, String fieldName) {
        if (fieldCache.contains(clazz, (Object)fieldName)) {
            return (Field)fieldCache.get(clazz, (Object)fieldName);
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldCache.put(clazz, (Object)fieldName, (Object)field);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Method getMethodCached(Class<?> clazz, String methodName) {
        if (methodCache.contains(clazz, (Object)methodName)) {
            return (Method)methodCache.get(clazz, (Object)methodName);
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            methodCache.put(clazz, (Object)methodName, (Object)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getMethodCached(Class<?> clazz, String methodName, boolean looping, Class<?> ... parameterTypes) {
        if (methodCache.contains(clazz, (Object)methodName)) {
            return (Method)methodCache.get(clazz, (Object)methodName);
        }
        try {
            Method method = null;
            if (looping) {
                Method[] methodArray = clazz.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equals(methodName) && m.getParameterTypes().equals(parameterTypes)) {
                        method = m;
                        method.setAccessible(true);
                        methodCache.put(clazz, (Object)methodName, (Object)method);
                        break;
                    }
                    ++n2;
                }
                return method;
            }
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            methodCache.put(clazz, (Object)methodName, (Object)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

