/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.nms.v1_17_R1;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.betterflee.AnimalFleeTweak;
import com.github.sachin.tweakin.nbtapi.nms.NMSHelper;
import com.github.sachin.tweakin.utils.PaperUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;

public class NMSHandler
extends NMSHelper {
    private net.minecraft.world.item.ItemStack nmsItem;
    private NBTTagCompound compound;

    public NMSHandler() {
    }

    public NMSHandler(ItemStack item) {
        if (item == null) {
            return;
        }
        this.nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.compound = this.nmsItem.getOrCreateTag();
    }

    @Override
    public NMSHelper newItem(ItemStack item) {
        return new NMSHandler(item);
    }

    @Override
    public void setString(String key, String value) {
        this.compound.setString(key, value);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.compound.setBoolean(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.compound.setInt(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.compound.setLong(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.compound.setDouble(key, value);
    }

    @Override
    public String getString(String key) {
        return this.compound.getString(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.compound.getBoolean(key);
    }

    @Override
    public int getInt(String key) {
        return this.compound.getInt(key);
    }

    @Override
    public long getLong(String key) {
        return this.compound.getLong(key);
    }

    @Override
    public double getDouble(String key) {
        return this.compound.getDouble(key);
    }

    @Override
    public boolean hasKey(String key) {
        return this.compound.hasKey(key);
    }

    @Override
    public ItemStack getItem() {
        this.nmsItem.save(this.compound);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)this.nmsItem);
    }

    @Override
    public void removeKey(String key) {
        this.compound.remove(key);
    }

    @Override
    public void placeWater(org.bukkit.block.Block block) {
        Location loc = block.getLocation();
        BlockPosition blockPos = new BlockPosition(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        IBlockData iBlockData = level.getType(blockPos);
        Block nmsBlock = iBlockData.getBlock();
        if (nmsBlock instanceof IFluidContainer) {
            ((IFluidContainer)nmsBlock).place((GeneratorAccess)level, blockPos, iBlockData, FluidTypes.c.a(false));
        }
    }

    @Override
    public void attack(Player player, Entity target) {
        ((CraftPlayer)player).getHandle().attack(((CraftEntity)target).getHandle());
        ((CraftPlayer)player).getHandle().resetAttackCooldown();
    }

    @Override
    public boolean placeItem(Player player, Location location, ItemStack item, BlockFace hitFace, String tweakName, boolean playSound) {
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        BlockPosition pos = new BlockPosition(location.getX(), location.getY(), location.getZ());
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        ItemActionContext context = new ItemActionContext((EntityHuman)nmsPlayer, EnumHand.a, new MovingObjectPositionBlock(new Vec3D(0.5, 1.0, 0.5), EnumDirection.b, pos, false));
        EnumInteractionResult res = nmsItem.getItem().a(context);
        if (res == EnumInteractionResult.b) {
            player.swingMainHand();
            BaseBlockPosition vec = context.getClickPosition().shift(context.getClickedFace());
            BlockPosition placedPos = new BlockPosition(vec.getX(), vec.getY(), vec.getZ());
            org.bukkit.block.Block placedBlock = player.getWorld().getBlockAt(placedPos.getX(), placedPos.getY(), placedPos.getZ());
            if (placedBlock.getType() == Material.BARRIER) {
                placedBlock.setType(Material.AIR);
            }
            if (playSound) {
                player.getWorld().playSound(location, location.getBlock().getBlockData().getSoundGroup().getPlaceSound(), 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void spawnVillager(Villager villager, boolean update) {
        EntityVillager vil = (EntityVillager)((CraftEntity)villager).getHandle();
        vil.bP.a(2, (PathfinderGoal)new PathfinderGoalTempt((EntityCreature)vil, 0.6, RecipeItemStack.a((IMaterial[])new IMaterial[]{Items.ff}), false));
    }

    @Override
    public void avoidPlayer(Entity entity, Player player, ConfigurationSection config) {
        EntityAnimal animal = (EntityAnimal)((CraftEntity)entity).getHandle();
        List list = animal.t.a(EntityAnimal.class, animal.getBoundingBox().g(5.0));
        if (Tweakin.getPlugin().isRunningPaper) {
            PaperUtils.removePanicGoal(entity);
        }
        if (!list.isEmpty()) {
            for (EntityAnimal en : list) {
                CraftEntity bEn = en.getBukkitEntity();
                if (bEn.getType() != entity.getType() || bEn.getPersistentDataContainer().has(AnimalFleeTweak.key, PersistentDataType.INTEGER) && config.getBoolean("ignore-breeded")) continue;
                en.bP.a(1, new FleePathFinder<EntityPlayer>((EntityCreature)en, EntityPlayer.class, config.getInt("max-radius"), config.getDouble("walk-speed"), config.getDouble("sprint-speed"), pl -> pl.getUniqueID() == player.getUniqueId(), config.getInt("cooldown")));
            }
        }
    }

    @Override
    public boolean matchAxoltlVariant(Entity entity, String color) {
        return ((Axolotl)entity).getVariant().toString().equals(color);
    }

    @Override
    public boolean matchFrogVariant(Entity entity, String variant) {
        return false;
    }

    @Override
    public boolean isScreamingGoat(Entity entity) {
        return ((Goat)entity).isScreaming();
    }

    @Override
    public List<Entity> getEntitiesWithinRadius(int radius, Entity center) {
        net.minecraft.world.entity.Entity entity = ((CraftEntity)center).getHandle();
        return entity.t.getEntities(entity, entity.getBoundingBox().g((double)radius)).stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList());
    }

    @Override
    public void applyHeadTexture(SkullMeta meta, String b64) {
        try {
            Method metaSetProfileMethod = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            metaSetProfileMethod.setAccessible(true);
            metaSetProfileMethod.invoke((Object)meta, this.makeProfile(b64));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            try {
                Field metaProfileField = meta.getClass().getDeclaredField("profile");
                metaProfileField.setAccessible(true);
                metaProfileField.set(meta, this.makeProfile(b64));
            }
            catch (IllegalAccessException | NoSuchFieldException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    @Override
    public ItemStack createMap(Location dist, byte zoom, boolean biomePreview) {
        return null;
    }

    public GameProfile makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        GameProfile profile = new GameProfile(id, "someName");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", b64));
        return profile;
    }

    private static class FleePathFinder<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private int tick = 0;
        private final int cooldown;

        public FleePathFinder(EntityCreature entity, Class<T> avoider, float maxDis, double walkSpeedModifier, double sprintSpeedModifier, Predicate<EntityLiving> condition, int cooldown) {
            super(entity, avoider, maxDis, walkSpeedModifier, sprintSpeedModifier, condition);
            this.cooldown = cooldown * 20;
        }

        public boolean a() {
            if (this.tick > this.cooldown) {
                return false;
            }
            ++this.tick;
            return super.a();
        }
    }
}

