/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.trowel;

import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.modules.reacharound.ReachAroundTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="trowel")
public class TrowelItem
extends TweakItem
implements Listener {
    private List<Player> players = new ArrayList<Player>();

    @Override
    public void register() {
        super.register();
        this.registerRecipe();
    }

    @Override
    public void unregister() {
        super.unregister();
        this.unregisterRecipe();
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.hasPermission(player, Permissions.TROWEL)) {
            return;
        }
        if (!this.hasItem(player, EquipmentSlot.HAND)) {
            return;
        }
        e.setCancelled(true);
        if (this.players.contains(player)) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        Block block = clickedBlock.getRelative(e.getBlockFace());
        if (clickedBlock.isPassable()) {
            block = clickedBlock;
        }
        this.placeBlock(block.getLocation(), player, e.getBlockFace(), false, null);
    }

    public void placeBlock(Location loc, final Player player, BlockFace hitFace, boolean isReacharound, ReachAroundTweak instance) {
        List<ItemStack> hotBar = this.getHotBarContents(player);
        ItemStack iteminHand = player.getInventory().getItemInMainHand().clone();
        TweakItem.UsedItem usedItem = new TweakItem.UsedItem(this, iteminHand);
        if (!hotBar.isEmpty()) {
            ItemStack item = hotBar.get(new Random().nextInt(hotBar.size()));
            if (isReacharound && this.matchString(item.getType().toString(), instance.getConfig().getStringList("black-list-materials"))) {
                return;
            }
            player.getInventory().setItemInMainHand(item);
            boolean placed = this.getPlugin().getNmsHelper().placeItem(player, loc, player.getInventory().getItemInMainHand(), hitFace, this.getName(), true);
            player.getInventory().setItemInMainHand(iteminHand);
            this.players.add(player);
            new BukkitRunnable(){

                public void run() {
                    TrowelItem.this.players.remove(player);
                }
            }.runTaskLater((Plugin)this.getPlugin(), 4L);
            if (placed) {
                if (usedItem.getUses() != -1 && this.getConfig().getBoolean("take-damage", false) && player.getGameMode() != GameMode.CREATIVE) {
                    if (usedItem.getUses() >= iteminHand.getType().getMaxDurability()) {
                        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        player.getInventory().setItemInMainHand(null);
                    } else {
                        usedItem.use();
                        player.getInventory().setItemInMainHand(usedItem.getItem());
                    }
                } else {
                    player.getInventory().setItemInMainHand(iteminHand);
                }
                if (player.getGameMode() != GameMode.CREATIVE) {
                    item.setAmount(item.getAmount() - 1);
                }
            }
        }
    }

    private List<ItemStack> getHotBarContents(Player player) {
        PlayerInventory inv = player.getInventory();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int i = 0;
        while (i < 9) {
            ItemStack item = inv.getItem(i);
            if (item != null && !item.isSimilar(player.getInventory().getItemInMainHand()) && item.getType().isBlock()) {
                list.add(inv.getItem(i));
            }
            ++i;
        }
        return list;
    }
}

