/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.slimebucket;

import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="slime-in-bucket")
public class SlimeInBucket
extends TweakItem
implements Listener {
    private SlimeRunnable runnable;
    private final Set<Player> enabled = new HashSet<Player>();

    @Override
    public void register() {
        super.register();
        if (this.runnable != null) {
            this.runnable.cancel();
        }
        this.runnable = new SlimeRunnable();
        this.runnable.runTaskTimer((Plugin)this.plugin, 1L, this.getConfig().getLong("interval-ticks", 20L));
        Bukkit.getOnlinePlayers().forEach(p -> {
            boolean bl = this.enabled.add((Player)p);
        });
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.enabled.add(e.getPlayer());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.enabled.remove(e.getPlayer());
    }

    @Override
    public void unregister() {
        super.unregister();
        if (this.runnable != null) {
            this.runnable.cancel();
            this.enabled.clear();
        }
    }

    @Override
    public void buildItem() {
        super.buildItem();
        ItemMeta meta = this.item.getItemMeta();
        meta.setCustomModelData(Integer.valueOf(this.getConfig().getInt("model-undetected", 103)));
        this.item.setItemMeta(meta);
    }

    @EventHandler
    public void onSlimePickUp(PlayerInteractEntityEvent e) {
        if (e.getRightClicked().getType() != EntityType.SLIME) {
            return;
        }
        Slime slime = (Slime)e.getRightClicked();
        if (slime.getSize() != 1) {
            return;
        }
        if (this.getBlackListWorlds().contains(slime.getWorld().getName())) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.hasPermission(player, Permissions.SLIMEBUCKET_PICKUP)) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null) {
            return;
        }
        if (item.getType() != Material.BUCKET) {
            return;
        }
        e.setCancelled(true);
        player.swingMainHand();
        item.setAmount(item.getAmount() - 1);
        ItemStack slimeBucket = this.getItem().clone();
        if (slime.getCustomName() != null) {
            NBTItem nbtItem = new NBTItem(slimeBucket);
            nbtItem.setString("tweakin-slime-name", slime.getCustomName());
            slimeBucket = nbtItem.getItem();
        }
        player.getInventory().addItem(new ItemStack[]{slimeBucket});
        slime.remove();
    }

    @EventHandler
    public void onSlimeDeploy(PlayerInteractEvent e) {
        if (e.getAction() != Action.LEFT_CLICK_BLOCK || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = e.getPlayer();
        if (!this.hasItem(player, EquipmentSlot.HAND)) {
            return;
        }
        if (this.getBlackListWorlds().contains(player.getWorld().getName())) {
            return;
        }
        Block clickedBlock = e.getClickedBlock();
        Block relative = clickedBlock.getRelative(e.getBlockFace());
        if (relative.getType() != Material.AIR) {
            return;
        }
        Slime slime = (Slime)player.getWorld().spawn(relative.getLocation().add(0.5, 0.5, 0.5), Slime.class);
        ItemStack slimeBucket = player.getInventory().getItem(EquipmentSlot.HAND);
        NBTItem nbtItem = new NBTItem(slimeBucket);
        if (nbtItem.hasKey("tweakin-slime-name")) {
            slime.setCustomName(nbtItem.getString("tweakin-slime-name"));
        }
        slime.setSize(1);
        e.getItem().setAmount(e.getItem().getAmount() - 1);
        player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
    }

    private class SlimeRunnable
    extends BukkitRunnable {
        private SlimeRunnable() {
        }

        public void run() {
            if (SlimeInBucket.this.enabled.isEmpty()) {
                return;
            }
            SlimeInBucket.this.enabled.forEach(player -> {
                ItemMeta meta;
                ItemStack item;
                if (SlimeInBucket.this.getBlackListWorlds().contains(player.getWorld().getName()) || !SlimeInBucket.this.hasPermission((Player)player, Permissions.SLIMEBUCKET_DETECT)) {
                    return;
                }
                int model = 0;
                Location loc = player.getLocation();
                model = loc.getChunk().isSlimeChunk() && SlimeInBucket.this.getConfig().getInt("max-y-level") > loc.getBlockY() ? SlimeInBucket.this.getConfig().getInt("model-detected", 104) : SlimeInBucket.this.getConfig().getInt("model-undetected", 103);
                if (SlimeInBucket.this.hasItem((Player)player, EquipmentSlot.HAND)) {
                    item = player.getInventory().getItemInMainHand();
                    meta = item.getItemMeta();
                    meta.setCustomModelData(Integer.valueOf(model));
                    item.setItemMeta(meta);
                }
                if (SlimeInBucket.this.isSimilar(player.getInventory().getItemInOffHand())) {
                    item = player.getInventory().getItemInOffHand();
                    meta = item.getItemMeta();
                    meta.setCustomModelData(Integer.valueOf(model));
                    item.setItemMeta(meta);
                }
            });
        }
    }
}

