/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.silencemobs;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Tweak(name="silence-mobs")
public class SilenceMobsTweak
extends BaseTweak
implements Listener {
    private List<String> silenceNames = new ArrayList<String>();
    private List<String> unsilenceNames = new ArrayList<String>();
    private List<String> blackListAnimals = new ArrayList<String>();

    @Override
    public void reload() {
        super.reload();
        this.silenceNames = this.getConfig().getStringList("silence-names");
        this.unsilenceNames = this.getConfig().getStringList("unsilence-names");
        this.blackListAnimals = this.getConfig().getStringList("black-list-mobs");
    }

    @EventHandler
    public void nameTagUseEvent(PlayerInteractEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = e.getPlayer();
        if (this.getBlackListWorlds().contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        Entity entity = e.getRightClicked();
        if (this.blackListAnimals.contains(entity.getType().toString())) {
            return;
        }
        ItemStack clickedItem = player.getInventory().getItemInMainHand();
        if (clickedItem == null) {
            return;
        }
        if (clickedItem.getType() != Material.NAME_TAG) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        boolean fired = false;
        if (this.silenceNames.contains(meta.getDisplayName()) && !entity.isSilent() && this.hasPermission(player, Permissions.SILENCEMOBS_SILENCE)) {
            entity.setSilent(true);
            player.sendMessage(this.getTweakManager().getMessageManager().getMessage("mob-silenced").replace("%name%", entity.getType().toString()));
            fired = true;
        } else if (this.unsilenceNames.contains(meta.getDisplayName()) && entity.isSilent() && this.hasPermission(player, Permissions.SILENCEMOBS_UNSILENCE)) {
            entity.setSilent(false);
            player.sendMessage(this.getTweakManager().getMessageManager().getMessage("mob-unsilenced").replace("%name%", entity.getType().toString()));
            fired = true;
        }
        if (!fired) {
            return;
        }
        player.swingMainHand();
        if (!this.getConfig().getBoolean("rename-mob", false)) {
            e.setCancelled(true);
        }
        if (player.getGameMode() == GameMode.SURVIVAL && this.getConfig().getBoolean("consume-tag", false)) {
            clickedItem.setAmount(clickedItem.getAmount() - 1);
        }
    }
}

