/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.rotationwrench;

import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="rotation-wrench")
public class RotationWrenchItem
extends TweakItem
implements Listener {
    @Config(key="rotatable-materials")
    private List<String> rotateableMaterials = new ArrayList<String>();
    private List<Player> cooldownPlayers = new ArrayList<Player>();

    @Override
    public void register() {
        super.register();
        this.registerRecipe();
    }

    @Override
    public void unregister() {
        super.unregister();
        this.unregisterRecipe();
    }

    @EventHandler
    public void onDispense(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DISPENSER && this.getConfig().getBoolean("dispenser-usable") && this.isSimilar(e.getItem())) {
            Directional dispenserDirection = (Directional)e.getBlock().getBlockData();
            Block block = e.getBlock().getRelative(dispenserDirection.getFacing());
            if (this.matchString(block.getType().toString(), this.rotateableMaterials)) {
                e.setCancelled(true);
                if (block.getBlockData() instanceof Directional) {
                    Directional directional = (Directional)block.getBlockData();
                    BlockFace currentFace = directional.getFacing();
                    ArrayList rotations = new ArrayList(directional.getFaces());
                    if (rotations.indexOf(currentFace) == rotations.size() - 1) {
                        directional.setFacing((BlockFace)rotations.get(0));
                    } else {
                        directional.setFacing((BlockFace)rotations.get(rotations.indexOf(currentFace) + 1));
                    }
                    block.setBlockData((BlockData)directional);
                    block.getState().update(true, true);
                } else if (block.getBlockData() instanceof Orientable) {
                    Axis currentFace;
                    Orientable orientable = (Orientable)block.getBlockData();
                    ArrayList axises = new ArrayList(orientable.getAxes());
                    if (axises.indexOf(currentFace = orientable.getAxis()) == axises.size() - 1) {
                        orientable.setAxis((Axis)axises.get(0));
                    } else {
                        orientable.setAxis((Axis)axises.get(axises.indexOf(currentFace) + 1));
                    }
                    block.setBlockData((BlockData)orientable);
                    block.getState().update(true, true);
                }
            }
        }
    }

    @EventHandler
    public void interactEvent(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        final Player player = e.getPlayer();
        if (!this.hasPermission(player, Permissions.ROTATION_WRENCH)) {
            return;
        }
        if (!this.hasItem(player, e.getHand())) {
            return;
        }
        Block block = e.getClickedBlock();
        if (!this.matchString(block.getType().toString(), this.rotateableMaterials)) {
            return;
        }
        boolean success = false;
        if (this.cooldownPlayers.contains(player)) {
            return;
        }
        ItemStack item = e.getItem().clone();
        if (this.plugin.griefCompat != null && !this.plugin.griefCompat.canBuild(player, block.getLocation(), block.getType())) {
            return;
        }
        if (block.getBlockData() instanceof Directional) {
            Directional directional = (Directional)block.getBlockData();
            BlockFace currentFace = directional.getFacing();
            ArrayList rotations = new ArrayList(directional.getFaces());
            success = true;
            e.setCancelled(true);
            if (rotations.indexOf(currentFace) == rotations.size() - 1) {
                directional.setFacing((BlockFace)rotations.get(0));
            } else {
                directional.setFacing((BlockFace)rotations.get(rotations.indexOf(currentFace) + 1));
            }
            block.setBlockData((BlockData)directional);
            block.getState().update(true, true);
        } else if (block.getBlockData() instanceof Orientable) {
            Orientable orientable = (Orientable)block.getBlockData();
            ArrayList axises = new ArrayList(orientable.getAxes());
            Axis currentFace = orientable.getAxis();
            success = true;
            if (axises.indexOf(currentFace) == axises.size() - 1) {
                orientable.setAxis((Axis)axises.get(0));
            } else {
                orientable.setAxis((Axis)axises.get(axises.indexOf(currentFace) + 1));
            }
            block.setBlockData((BlockData)orientable);
            block.getState().update(true, true);
        }
        if (success) {
            if (this.plugin.isPost1_18()) {
                player.getInventory().setItemInMainHand(item);
            }
            this.cooldownPlayers.add(player);
            new BukkitRunnable(){

                public void run() {
                    RotationWrenchItem.this.cooldownPlayers.remove(player);
                }
            }.runTaskLater((Plugin)this.getPlugin(), 5L);
        }
    }
}

