/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.reacharound;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.modules.reacharound.ReachAroundRunnable;
import com.github.sachin.tweakin.modules.reacharound.ToggleCommand;
import com.github.sachin.tweakin.modules.trowel.TrowelItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

@Tweak(name="reach-around")
public class ReachAroundTweak
extends BaseTweak
implements Listener {
    private Map<UUID, BukkitTask> currentTasks = new HashMap<UUID, BukkitTask>();
    public static final List<UUID> reachAroundPlacers = new ArrayList<UUID>();
    private int color;
    final NamespacedKey key = new NamespacedKey((Plugin)this.getPlugin(), "reacharound");
    final NamespacedKey firstKey = new NamespacedKey((Plugin)this.getPlugin(), "reacharound-firstjoin");
    private List<String> blackListWorlds = new ArrayList<String>();
    private ToggleCommand command;

    @Override
    public void onLoad() {
        this.command = new ToggleCommand(this);
    }

    @Override
    public List<String> getBlackListWorlds() {
        return this.blackListWorlds;
    }

    @Override
    public void register() {
        super.register();
        this.registerCommands(this.command);
    }

    @Override
    public void unregister() {
        super.unregister();
        this.unregisterCommands(this.command);
    }

    @Override
    public void reload() {
        super.reload();
        if (this.plugin.isPost1_17()) {
            this.color = this.getColor("0,16,0", this.getConfig().getInt("transparency", 100));
            this.plugin.getLogger().info("Using 0,16,0 as color for reach-around, due to other color channels being removed after 1.17");
        } else {
            this.color = this.getColor(this.getConfig().getString("color", "255,255,255"), this.getConfig().getInt("transparency", 100));
        }
        this.blackListWorlds = this.getConfig().getStringList("black-list-worlds");
    }

    @EventHandler
    public void serverReload(ServerLoadEvent e) {
        if (this.registered) {
            this.currentTasks.values().forEach(t -> t.cancel());
            this.currentTasks.clear();
            Bukkit.getOnlinePlayers().forEach(p -> {
                if (p.getPersistentDataContainer().has(this.key, PersistentDataType.INTEGER)) {
                    this.creatPlayerTask((Player)p);
                }
            });
        }
    }

    public int getColor() {
        return this.color;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (this.blackListWorlds.contains(player.getWorld().getName())) {
            return;
        }
        if (!player.getPersistentDataContainer().has(this.firstKey, PersistentDataType.INTEGER) && this.getConfig().getBoolean("enabled-on-first-join", true)) {
            this.creatPlayerTask(player);
            player.getPersistentDataContainer().set(this.key, PersistentDataType.INTEGER, (Object)1);
            player.getPersistentDataContainer().set(this.firstKey, PersistentDataType.INTEGER, (Object)1);
        } else if (!this.getCurrentTasks().containsKey(player.getUniqueId()) && player.getPersistentDataContainer().has(this.key, PersistentDataType.INTEGER)) {
            this.creatPlayerTask(e.getPlayer());
        }
    }

    @EventHandler
    public void onWorldChangeEvent(PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        if (!this.getCurrentTasks().containsKey(player.getUniqueId())) {
            if (!this.blackListWorlds.contains(player.getWorld().getName())) {
                this.creatPlayerTask(e.getPlayer());
            }
        } else if (this.blackListWorlds.contains(player.getWorld().getName())) {
            BukkitTask task = this.getCurrentTasks().remove(player.getUniqueId());
            task.cancel();
        }
    }

    public void creatPlayerTask(Player player) {
        if (this.getConfig().getBoolean("show-highlight", true) && this.hasPermission(player, Permissions.REACHAROUND_HIGHLIGHT)) {
            ReachAroundRunnable runnable = new ReachAroundRunnable(this, player);
            BukkitTask task = runnable.runTaskTimer((Plugin)this.getPlugin(), 60L, 2L);
            this.currentTasks.put(player.getUniqueId(), task);
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        UUID player = e.getPlayer().getUniqueId();
        if (this.getCurrentTasks().containsKey(player)) {
            BukkitTask task = this.getCurrentTasks().get(player);
            task.cancel();
            this.getCurrentTasks().remove(player);
        }
    }

    @EventHandler
    public void blockPlaceEvent(PlayerInteractEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (e.getItem() == null) {
            return;
        }
        Player player = e.getPlayer();
        if (!player.getPersistentDataContainer().has(this.key, PersistentDataType.INTEGER)) {
            return;
        }
        ItemStack item = e.getItem();
        for (TweakItem tItem : this.getTweakManager().getRegisteredItems()) {
            Location loc;
            TrowelItem trowelItem;
            if (!(tItem instanceof TrowelItem) || !(trowelItem = (TrowelItem)tItem).hasItem(player, EquipmentSlot.HAND) || (loc = this.getPlayerReachAroundTarget(player)) == null) continue;
            trowelItem.placeBlock(loc, player, BlockFace.UP, true, this);
            this.plugin.addPlacedPlayer(player);
            return;
        }
        if (this.matchString(item.getType().toString(), this.getConfig().getStringList("black-list-materials"))) {
            return;
        }
        if (!item.getType().isBlock()) {
            return;
        }
        Location loc = this.getPlayerReachAroundTarget(player);
        if (loc != null) {
            this.plugin.addPlacedPlayer(player);
            reachAroundPlacers.add(player.getUniqueId());
            boolean placed = this.getPlugin().getNmsHelper().placeItem(player, loc, e.getItem(), BlockFace.UP, this.getName(), true);
            reachAroundPlacers.remove(player.getUniqueId());
            if (placed && player.getGameMode() != GameMode.CREATIVE && !this.plugin.isPost1_18()) {
                item.setAmount(item.getAmount() - 1);
            }
        }
    }

    public Location getPlayerReachAroundTarget(Player player) {
        RayTraceResult rayTraceResult = player.getWorld().rayTraceBlocks(player.getEyeLocation(), player.getEyeLocation().getDirection(), 5.0);
        if (rayTraceResult == null) {
            Location target = this.getPlayerVerticalReachAround(player);
            if (target != null) {
                return target;
            }
            target = this.getPlayerHorizonTalReachAround(player);
            if (target != null) {
                return target;
            }
        }
        return null;
    }

    public Location getPlayerVerticalReachAround(Player player) {
        if (!this.hasPermission(player, Permissions.REACHAROUND_VERT)) {
            return null;
        }
        Vector vec = new Vector(0.0, 0.5, 0.0);
        RayTraceResult rayTrace = player.getWorld().rayTraceBlocks(player.getEyeLocation(), player.getEyeLocation().getDirection().clone().add(vec), 5.0);
        if (rayTrace != null && rayTrace.getHitBlock() != null) {
            Location target;
            Location block = rayTrace.getHitBlock().getLocation();
            Location playerLoc = player.getLocation();
            if (playerLoc.getZ() - block.getZ() < 1.3 && playerLoc.getY() - block.getY() == 1.0 && playerLoc.getX() - block.getX() < 1.3 && (target = block.subtract(0.0, 1.0, 0.0)).getBlock().getType() == Material.AIR) {
                return target;
            }
        }
        return null;
    }

    public Location getPlayerHorizonTalReachAround(Player player) {
        if (!this.hasPermission(player, Permissions.REACHAROUND_HORI)) {
            return null;
        }
        Location playerLoc = player.getLocation();
        BlockFace facing = player.getFacing();
        Vector direction = player.getEyeLocation().getDirection();
        Vector vec = new Vector(0.5 * (double)facing.getModX(), 0.0, 0.5 * (double)facing.getModZ());
        RayTraceResult rayTrace = player.getWorld().rayTraceBlocks(player.getEyeLocation(), direction.clone().subtract(vec), 4.0);
        if (rayTrace != null && rayTrace.getHitBlock() != null) {
            Block target;
            Location loc = rayTrace.getHitBlock().getLocation();
            double distance = playerLoc.getX() - loc.getX() + (playerLoc.getY() - loc.getY()) + (playerLoc.getZ() - loc.getZ()) / 3.0;
            if (distance < 1.85 && distance > 1.3 && (target = loc.getBlock().getRelative(player.getFacing())).getType() == Material.AIR) {
                return target.getLocation();
            }
        }
        return null;
    }

    public int getColor(String str, int alpha) {
        String[] array = str.replace(" ", "").split(",");
        if (array.length == 0) {
            return 100;
        }
        if (array.length != 3) {
            return 100;
        }
        int red = Integer.parseInt(array[0]);
        int green = Integer.parseInt(array[1]);
        int blue = Integer.parseInt(array[2]);
        int encoded = 0;
        encoded |= blue;
        encoded |= green << 8;
        encoded |= red << 16;
        return encoded |= alpha << 24;
    }

    public Map<UUID, BukkitTask> getCurrentTasks() {
        return this.currentTasks;
    }
}

