/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.morerecipes.recipes.universaldyeing;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.morerecipes.BaseRecipe;
import com.github.sachin.tweakin.modules.morerecipes.MoreRecipesTweak;
import com.github.sachin.tweakin.modules.morerecipes.recipes.universaldyeing.Dye;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class UniversalDyeing
extends BaseRecipe {
    private static final List<Material> CONCRETES = new ArrayList<Material>();
    private static final List<Material> CONCRETE_POWDERS = new ArrayList<Material>();
    private static final List<Material> TERRACOTTAS = new ArrayList<Material>();
    private static final List<Material> stainedGlasses = new ArrayList<Material>();
    private static final List<Material> STAINED_GLASS_PANES = new ArrayList<Material>();
    private static final List<Material> CANDLES = new ArrayList<Material>();

    static {
        Dye[] dyeArray = Dye.values();
        int n = dyeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dye dye = dyeArray[n2];
            CONCRETES.add(dye.concrete);
            CONCRETE_POWDERS.add(dye.concretePowder);
            TERRACOTTAS.add(dye.terracotta);
            stainedGlasses.add(dye.stainedGlass);
            STAINED_GLASS_PANES.add(dye.stainedGlassPane);
            CANDLES.add(dye.candle);
            ++n2;
        }
    }

    public UniversalDyeing(MoreRecipesTweak instance) {
        super("universal-dyeing", instance);
    }

    @Override
    public void register() {
        ConfigurationSection config = this.instance.getRecipeFile().getConfigurationSection(this.name);
        Dye[] dyeArray = Dye.values();
        int n = dyeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dye dye = dyeArray[n2];
            if (config.getBoolean("wool.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.wool, new ArrayList<Material>(Tag.WOOL.getValues()));
            }
            if (config.getBoolean("concrete.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.concrete, new ArrayList<Material>(CONCRETES));
            }
            if (config.getBoolean("concrete_powder.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.concretePowder, new ArrayList<Material>(CONCRETE_POWDERS));
            }
            if (config.getBoolean("terracotta.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.terracotta, new ArrayList<Material>(TERRACOTTAS));
            }
            if (config.getBoolean("stained_glass.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.stainedGlass, new ArrayList<Material>(stainedGlasses));
            }
            if (config.getBoolean("stained_glass_pane.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.stainedGlassPane, new ArrayList<Material>(STAINED_GLASS_PANES));
            }
            if (config.getBoolean("bed.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.bed, new ArrayList<Material>(Tag.BEDS.getValues()));
            }
            if (config.getBoolean("carpet.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.carpet, new ArrayList<Material>(Tag.CARPETS.getValues()));
            }
            if (config.getBoolean("candle.single")) {
                this.addSingleShapelessRecipe(dye.dye, dye.candle, new ArrayList<Material>(Tag.CANDLES.getValues()));
            }
            if (config.getBoolean("wool.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.wool, new ArrayList<Material>(Tag.WOOL.getValues()));
            }
            if (config.getBoolean("concrete.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.concrete, new ArrayList<Material>(CONCRETES));
            }
            if (config.getBoolean("concrete_powder.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.concretePowder, new ArrayList<Material>(CONCRETE_POWDERS));
            }
            if (config.getBoolean("terracotta.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.terracotta, new ArrayList<Material>(TERRACOTTAS));
            }
            if (config.getBoolean("stained_glass.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.stainedGlass, new ArrayList<Material>(stainedGlasses));
            }
            if (config.getBoolean("stained_glass_pane.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.stainedGlassPane, new ArrayList<Material>(STAINED_GLASS_PANES));
            }
            if (config.getBoolean("bed.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.bed, new ArrayList<Material>(Tag.BEDS.getValues()));
            }
            if (config.getBoolean("carpet.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.carpet, new ArrayList<Material>(Tag.CARPETS.getValues()));
            }
            if (config.getBoolean("candle.sorounded")) {
                this.addSoroundedShapedRecipe(dye.dye, dye.candle, new ArrayList<Material>(Tag.CANDLES.getValues()));
            }
            ++n2;
        }
    }

    private void addSingleShapelessRecipe(Material dye, Material result, List<Material> ing) {
        NamespacedKey key = Tweakin.getKey(String.valueOf(this.name) + "_" + dye.toString().toLowerCase() + "_" + result.toString().toLowerCase() + "_single");
        ing.remove(result);
        ShapelessRecipe recipe = new ShapelessRecipe(key, new ItemStack(result)).addIngredient(dye).addIngredient((RecipeChoice)new RecipeChoice.MaterialChoice(ing));
        this.addRecipe(key, (Recipe)recipe);
    }

    private void addSoroundedShapedRecipe(Material dye, Material result, List<Material> ing) {
        NamespacedKey key = Tweakin.getKey(String.valueOf(this.name) + "_" + dye.toString().toLowerCase() + "_" + result.toString().toLowerCase() + "_sorounded");
        ing.remove(result);
        ShapedRecipe recipe = new ShapedRecipe(key, new ItemStack(result, 8)).shape(new String[]{"XXX", "XYX", "XXX"}).setIngredient('Y', dye).setIngredient('X', (RecipeChoice)new RecipeChoice.MaterialChoice(ing));
        this.addRecipe(key, (Recipe)recipe);
    }
}

